DELIMITER $$
DROP PROCEDURE IF EXISTS V20200520153838__Create_courseDepartments $$
CREATE PROCEDURE V20200520153838__Create_courseDepartments()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.TABLES WHERE table_schema=DATABASE() AND table_name='courses_departments')) THEN 
CREATE TABLE `courses_departments` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `courseId` BIGINT(20) NOT NULL,
  `departmentId` BIGINT(20) NOT NULL,
  `subDepartmentId` BIGINT(20) NULL DEFAULT NULL ,
  `weightage` BIGINT(11) NULL DEFAULT NULL ,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `courses_departments_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `courses_departments_courseId`
    FOREIGN KEY (`courseId`)
    REFERENCES `courses` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `courses_departments_departmentId`
    FOREIGN KEY (`departmentId`)
    REFERENCES `department` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
CONSTRAINT `courses_departments_subDepartmentId`
    FOREIGN KEY (`subDepartmentId`)
    REFERENCES `department` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `courses_departments_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20200520153838__Create_courseDepartments () $$ 
DROP PROCEDURE IF EXISTS V20200520153838__Create_courseDepartments $$ 
DELIMITER ;