DELIMITER $$
DROP PROCEDURE IF EXISTS V20200522092846__Alter_CourseReadingVariantAddAcademicTerm $$
CREATE PROCEDURE V20200522092846__Alter_CourseReadingVariantAddAcademicTerm()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='course_reading_variant' AND column_name in ("academicTermId", "dateRequired", "userRequestedBy"))) THEN 
ALTER TABLE `course_reading_variant` 
ADD COLUMN `academicTermId` BIGINT(20) NULL DEFAULT NULL AFTER `courseVariantId`,
ADD COLUMN `userRequestedBy` BIGINT(20) NULL DEFAULT NULL AFTER `academicTermId`,
ADD COLUMN `dateRequired` DATE NULL DEFAULT NULL AFTER `userRequestedBy`,
ADD INDEX `fk_course_reading_variant_1_idx` (`academicTermId` ASC),
ADD INDEX `fk_course_reading_variant_2_idx` (`userRequestedBy` ASC);
ALTER TABLE `course_reading_variant` 
ADD CONSTRAINT `fk_course_reading_variant_1`
  FOREIGN KEY (`academicTermId`)
  REFERENCES `academic_term` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
ADD CONSTRAINT `fk_course_reading_variant_2`
  FOREIGN KEY (`userRequestedBy`)
  REFERENCES `staffs` (`userId`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
END IF;

END $$
CALL V20200522092846__Alter_CourseReadingVariantAddAcademicTerm() $$
DROP PROCEDURE IF EXISTS V20200522092846__Alter_CourseReadingVariantAddAcademicTerm $$
DELIMITER ;