DELIMITER $$
DROP PROCEDURE IF EXISTS V20200522181751__Create_PaymentPlanAcadLocation $$
CREATE PROCEDURE V20200522181751__Create_PaymentPlanAcadLocation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='payment_plan_acad_location')) THEN 
CREATE TABLE `payment_plan_acad_location` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT NOT NULL,
  `progBatchSeatTypeId` BIGINT NOT NULL,
  `paymentPlanId` BIGINT NOT NULL,
  `mappingStatus` VARCHAR(255) NOT NULL,
  `createdById` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` BIGINT NULL,
  PRIMARY KEY (`id`),
  INDEX `fk_payment_plan_acad_location_academy_location_idx` (`academyLocationId` ASC),
  INDEX `fk_payment_plan_acad_location_to_pbst_idx` (`progBatchSeatTypeId` ASC),
  INDEX `fk_payment_plan_acad_location_to_payment_plan_idx` (`paymentPlanId` ASC),
  INDEX `fk_payment_plan_acad_location_to_created_by_user_idx` (`createdById` ASC),
  INDEX `fk_payment_plan_acad_location_to_user_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_payment_plan_acad_location_academy_location`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_acad_location_to_pbst`
    FOREIGN KEY (`progBatchSeatTypeId`)
    REFERENCES `prog_batch_seat_config` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_acad_location_to_payment_plan`
    FOREIGN KEY (`paymentPlanId`)
    REFERENCES `payment_plan` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_acad_location_to_created_by_user`
    FOREIGN KEY (`createdById`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
  CONSTRAINT `fk_payment_plan_acad_location_to_user`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT);
END IF; 

END $$
CALL V20200522181751__Create_PaymentPlanAcadLocation () $$ 
DROP PROCEDURE IF EXISTS V20200522181751__Create_PaymentPlanAcadLocation $$ 
DELIMITER ;