DELIMITER $$
DROP PROCEDURE IF EXISTS V20200603120812__Insert_StudentIdCardSnjbReportTemp $$
CREATE PROCEDURE V20200603120812__Insert_StudentIdCardSnjbReportTemp()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'SNJB_STUDENT_ID_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES ('7', 'SNJB_STUDENT_ID_CARD', 'SNJB Student ID Card', 'SNJB_Student_ID_Card.png', 'CommonReport_IdCard_Horizontal_ATMCardSize.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'SNJB_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');


IF EXISTS ((SELECT * FROM `report_template` WHERE `templateCode`='SNJB_STUDENT_ID_CARD')) THEN 
set @translationId = (SELECT `id` FROM `report_template` WHERE `templateCode`='SNJB_STUDENT_ID_CARD');
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@translationId, 'TRANS_ACADEMIC_YEAR', 'Academic Year :', NULL, NOW()),
(@translationId, 'TRANS_COURSE', 'Course :', NULL, NOW()),
(@translationId, 'TRANS_DATE_OF_BIRTH', 'Date of Birth :', NULL, NOW()),
(@translationId, 'TRANS_BLOOD_GROUP', 'Blood Group :', NULL, NOW()),
(@translationId, 'TRANS_CONTACT_NO', 'Contact No. :', NULL, NOW()),
(@translationId, 'TRANS_EMERGENCY_NO', 'Emergency No. :', NULL, NOW()),
(@translationId, 'TRANS_EMAIL_ID', 'Email ID :', NULL, NOW()),
(@translationId, 'TRANS_ADDRESS', 'Address :', NULL, NOW()),
(@translationId, 'TRANS_VALID_UPTO', 'Valid Upto Academic Year', NULL, NOW());
END IF; 

END IF; 

END $$
CALL V20200603120812__Insert_StudentIdCardSnjbReportTemp() $$
DROP PROCEDURE IF EXISTS V20200603120812__Insert_StudentIdCardSnjbReportTemp $$
DELIMITER ;