DELIMITER $$
DROP PROCEDURE IF EXISTS V20200604173138__Create_Program_CESM_CSM $$
CREATE PROCEDURE V20200604173138__Create_Program_CESM_CSM()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_group_cesm')) THEN
CREATE TABLE IF NOT EXISTS `program_group_cesm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,  
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'PROGRAM_GROUP_CESM')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'program_group_cesm','PROGRAM_GROUP_CESM','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_GROUP_CESM_ID')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'PROGRAM_GROUP_CESM_ID', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '100', '1', SYSDATE());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_GROUP_CESM_VALUE')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'PROGRAM_GROUP_CESM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '100', '1', SYSDATE());
END IF;


IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='program_group_cesm' and column_name in('itemCode', 'itemValue'))) THEN
ALTER TABLE `program_group_cesm` 
ADD UNIQUE INDEX `itemCode_UNIQUE` (`itemCode` ASC),
ADD UNIQUE INDEX `itemValue_UNIQUE` (`itemValue` ASC);
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='program_cesm')) THEN
CREATE TABLE IF NOT EXISTS `program_cesm` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
	`programGroupCESMId` BIGINT(20) NOT NULL,
	`itemCode` VARCHAR(255) NOT NULL,
	`itemValue` VARCHAR(255) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`),
	FOREIGN KEY (`programGroupCESMId`) REFERENCES `program_group_cesm`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF;

SET @currentTimeStamp = (SELECT CURRENT_TIMESTAMP);
SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
IF NOT EXISTS ((SELECT * FROM standard_master WHERE masterName = 'PROGRAM_CESM')) THEN
INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
VALUES (@standardMasterMaxId+1, NULL,'program_cesm','PROGRAM_CESM','Program & Courses','COMMON_MASTER',0,0,NULL,1,@currentTimeStamp);
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_GROUP_CESM_ID')) THEN
INSERT INTO `standard_master_items` (`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `fkTable`, `fkFieldName`, `fkDisplayField`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'programGroupCESM', 'PROGRAM_GROUP_CESM_ID', @standardMasterMaxId+1, 'Varchar', '1', b'1', 'program_group_cesm', 'id', 'code', b'0', b'0', b'0', '1', SYSDATE());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_CESM_ID')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'code', 'PROGRAM_CESM_ID', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '100', '1', SYSDATE());
END IF;

SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
IF NOT EXISTS ((SELECT * FROM standard_master_items WHERE standardMasterId = @standardMasterMaxId+1 and fieldLabel = 'PROGRAM_CESM_VALUE')) THEN
INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `maxLength`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@ItemsMaxId+1, 'value', 'PROGRAM_CESM_VALUE', @standardMasterMaxId+1, 'varchar', '3', 0, 0, 0, 0, '100', '1', SYSDATE());
END IF;


IF EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='program_cesm' and column_name in('itemCode', 'itemValue'))) THEN
ALTER TABLE `program_cesm` 
ADD UNIQUE INDEX `itemCode_UNIQUE` (`itemCode` ASC),
ADD UNIQUE INDEX `itemValue_UNIQUE` (`itemValue` ASC);
END IF;

END $$
CALL V20200604173138__Create_Program_CESM_CSM () $$ 
DROP PROCEDURE IF EXISTS V20200604173138__Create_Program_CESM_CSM $$ 
DELIMITER ;