DELIMITER $$
DROP PROCEDURE IF EXISTS V20200608160250__Insert_AssessmentGroupReport $$
CREATE PROCEDURE V20200608160250__Insert_AssessmentGroupReport()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'ASSESSMENT_GROUP_REPORT')) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'ASSESSMENT_GROUP_REPORT', 'Assessment Group Report', 'ASSESSMENT_GROUP_REPORT.png', 'Assessment_CommonReport.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'ASSESSMENT_GROUP_REPORT.jasper', 'AcademiaLogo.png'); 


set @assessmentGroup = (select max(id) from report_template where templateCode ='ASSESSMENT_GROUP_REPORT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
VALUES (@assessmentGroup, 'TRANS_DATE', 'Date :', '1', NOW()),
(@assessmentGroup, 'TRANS_PROGRAM_CATEGORY_NAME', 'Program Category :', '1', NOW()),
(@assessmentGroup, 'TRANS_SNO', 'Sr.No.', '1', NOW()),
(@assessmentGroup, 'TRANS_ASSESSMENT_GROUP_NAME', 'Assessment Group Name', '1', NOW()),
(@assessmentGroup, 'TRANS_REGULAR_STD', 'Regular Students', '1', NOW()),
(@assessmentGroup, 'TRANS_EX_STD', 'Ex Students', '1', NOW()),
(@assessmentGroup, 'TRANS_TOTAL_STD','Total Students', '1', NOW()),
(@assessmentGroup, 'TRANS_FORM_SUBMITTED', 'Form Submitted', '1', NOW()),
(@assessmentGroup, 'TRANS_FORM_NOT_SUBMITTED', 'Form Not Submitted', '1', NOW()),
(@assessmentGroup, 'TRANS_TOTAL_STD1', 'Total Students :', '1', NOW()),
(@assessmentGroup, 'TRANS_TOTAL_REGULAR_STD', 'Total Regular Students :', '1', NOW()),
(@assessmentGroup, 'TRANS_TOTAL_EX_STD', 'Total Ex Students :', '1', NOW());
 
END IF; 
  

END $$
CALL V20200608160250__Insert_AssessmentGroupReport() $$
DROP PROCEDURE IF EXISTS V20200608160250__Insert_AssessmentGroupReport $$
DELIMITER ;
