DELIMITER $$
DROP PROCEDURE IF EXISTS V20200619175019__Create_NonAcademicAchievements $$
CREATE PROCEDURE V20200619175019__Create_NonAcademicAchievements()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='non_academic_achievements')) THEN 
CREATE TABLE `non_academic_achievements` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `sportEventId` BIGINT(20) NULL,
  `levelEventId` BIGINT(20) NULL,
  `applicant_person_id` BIGINT(20) NULL,
  `person_id` BIGINT(20) NULL,
  `lastUpdate` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT(20) NULL,
  PRIMARY KEY (`id`),
  INDEX `person_id_idx` (`person_id` ASC),
  INDEX `applicant_person_id_idx` (`applicant_person_id` ASC),
  INDEX `levelEventId_idx` (`levelEventId` ASC),
  INDEX `sportEventId_idx` (`sportEventId` ASC),
  CONSTRAINT `sportEventId`
    FOREIGN KEY (`sportEventId`)
    REFERENCES `drop_down`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `levelEventId`
    FOREIGN KEY (`levelEventId`)
    REFERENCES `drop_down`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `applicant_person_id`
    FOREIGN KEY (`applicant_person_id`)
    REFERENCES `applicant_person`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `person_id`
    FOREIGN KEY (`person_id`)
    REFERENCES `persons`(`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200619175019__Create_NonAcademicAchievements () $$ 
DROP PROCEDURE IF EXISTS V20200619175019__Create_NonAcademicAchievements $$ 
DELIMITER ;