DELIMITER $$
DROP PROCEDURE IF EXISTS V20200721165855__Alter_courseRequisiteCriteria $$
CREATE PROCEDURE V20200721165855__Alter_courseRequisiteCriteria()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.COLUMNS WHERE table_schema=DATABASE() AND table_name='course_requisite_criteria' 
  AND column_name = 'courseId')) THEN 
ALTER TABLE `course_requisite_criteria` 
ADD COLUMN `courseId` BIGINT(20) NULL DEFAULT NULL AFTER `parentId`,
ADD COLUMN `restrictionValue` VARCHAR(45) NULL DEFAULT NULL AFTER `courseId`,
ADD COLUMN `examPassedId` BIGINT(20) NULL DEFAULT NULL AFTER `restrictionValue`,
ADD COLUMN `resultStatusId` BIGINT(20) NULL DEFAULT NULL AFTER `examPassedId`,
ADD COLUMN `subjectId` BIGINT(20) NULL DEFAULT NULL AFTER `resultStatusId`,
ADD COLUMN `educationFields` VARCHAR(45) NULL DEFAULT NULL AFTER `subjectId`,
ADD COLUMN `monthValid` VARCHAR(45) NULL DEFAULT NULL AFTER `educationFields`,
ADD COLUMN `scoreMethod` VARCHAR(45) NULL DEFAULT NULL AFTER `monthValid`;

ALTER TABLE `course_requisite_criteria` 
ADD INDEX `fk_course_requisite_criteria_4_idx` (`courseId` ASC),
ADD INDEX `fk_course_requisite_criteria_5_idx` (`examPassedId` ASC),
ADD INDEX `fk_course_requisite_criteria_6_idx` (`subjectId` ASC),
ADD INDEX `fk_course_requisite_criteria_7_idx` (`resultStatusId` ASC);
ALTER TABLE `course_requisite_criteria` 
ADD CONSTRAINT `fk_course_requisite_criteria_4`
  FOREIGN KEY (`courseId`)
  REFERENCES `courses` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
  ADD CONSTRAINT `fk_course_requisite_criteria_5`
  FOREIGN KEY (`examPassedId`)
  REFERENCES `exam_passed` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
  ADD CONSTRAINT `fk_course_requisite_criteria_6`
  FOREIGN KEY (`subjectId`)
  REFERENCES `subjects` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT,
  ADD CONSTRAINT `fk_course_requisite_criteria_7`
  FOREIGN KEY (`resultStatusId`)
  REFERENCES `result_status` (`id`)
  ON DELETE RESTRICT
  ON UPDATE RESTRICT;
  
END IF; 

END $$
CALL V20200721165855__Alter_courseRequisiteCriteria() $$
DROP PROCEDURE IF EXISTS V20200721165855__Alter_courseRequisiteCriteria $$
DELIMITER ;