DELIMITER $$
DROP PROCEDURE IF EXISTS V20200807144547__Insert_AdmissionFormSubmissionMsgTranslat $$
CREATE PROCEDURE V20200807144547__Insert_AdmissionFormSubmissionMsgTranslat()
BEGIN


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MESSAGING_TRANSLATIONS' AND keyName='APPLICANT_FORM_SUBMISSION')) THEN
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_FORM_SUBMISSION','Applicant Form Submission','Applicant Form Submission','Aansoekervorm indiening','Nộp đơn đăng ký',now(),1);														
	END IF;
	  
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MESSAGING_TRANSLATIONS' AND keyName='APPLICANT_FORM_SUBMISSION_DL')) THEN
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_FORM_SUBMISSION_DL','Applicant Form Submission DL','Applicant Form Submission DL','Aansoekervorm Voorlegging DL','Đăng ký Mẫu đơn DL',now(),1);														
	END IF;
	  	  
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE objectName='MESSAGING_TRANSLATIONS' AND keyName='APPLICANT_FORM_SUBMISSION_RECIPIENT')) THEN
	INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
	VALUES ('MESSAGING_TRANSLATIONS','APPLICANT_FORM_SUBMISSION_RECIPIENT','Applicant Form Submission Recipient','Applicant Form Submission Recipient','Aanvraer van die aansoekervorm','Người nộp đơn đăng ký',now(),1);														
	END IF; 
	  
	IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='APPLICANT_FORM_SUBMISSION_RECIPIENT')) THEN
	INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_FORM_SUBMISSION_RECIPIENT', 'Applicant Form Submission Recipient');													
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='APPLICANT_FORM_SUBMISSION_DL')) THEN
	INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_FORM_SUBMISSION_DL', 'Applicant Form Submission DL');													
	END IF;
	   
	IF NOT EXISTS ((SELECT * FROM `picklist_translation` WHERE `key`='APPLICANT_FORM_SUBMISSION')) THEN
	INSERT INTO `picklist_translation` (`key`, `en`) VALUES ('APPLICANT_FORM_SUBMISSION', 'Applicant Form Submission');													
	END IF;

END $$
CALL V20200807144547__Insert_AdmissionFormSubmissionMsgTranslat() $$
DROP PROCEDURE IF EXISTS V20200807144547__Insert_AdmissionFormSubmissionMsgTranslat $$
DELIMITER ;