DELIMITER $$
DROP PROCEDURE IF EXISTS V20200821214523__Update_sqldtproviderSendOfferLetter $$
CREATE PROCEDURE V20200821214523__Update_sqldtproviderSendOfferLetter()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_APPLICANT_DTP');
IF EXISTS ((select * from sql_dtprovider where dataProviderId = @dtproviderId)) THEN 
UPDATE `sql_dtprovider`
SET `sqlQuery` = "SELECT
   T2.id AS ID,
   T3.`salutationName` AS SALUTATION_NAME,
   T2.`firstName` AS FIRST_NAME,
   T2.`middleName` AS MIDDLE_NAME,
   T2.`lastName` AS LAST_NAME,
   T2.`emailId` AS EMAIL_ID,
   T2.`mobileNumber` AS MOBILE_NO,
   T2.`mobileCountryCode` AS MOBILE_CODE,
   T5.`loginId` AS LOGIN_ID,
   CONVERT(FROM_BASE64(T5.passwordBase64) USING utf8) AS PASSWORD,
   CONCAT(T9.addressText,' ',T10.cityName,', ',T11.countryName,', ',T12.countryRegionName) AS ACADEMY_LOCATION_ADDRESS
FROM
   `application` T1 
		INNER JOIN
	`applicant_person` T2 ON T2.id = T1.applicantPersonId 
		LEFT JOIN
	`salutations` T3 ON T3.`id` = T2.`salutationId`
		LEFT JOIN
	`external_user_association` T4 ON T4.`applicationId` = T1.`id`
		LEFT JOIN
	`external_users` T5 ON T5.`id` = T4.`externalUserId`
    LEFT JOIN
    application_program T6 ON T6.applicationId = T1.id
		LEFT OUTER JOIN
    academy_location T7 ON T7.id = T6.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T8 ON T8.academyLocationId = T7.id
		LEFT OUTER JOIN
    address T9 ON T9.id = T8.addressId && T9.addressTypeId=10
		LEFT OUTER JOIN
	city T10 ON T10.id = T9.cityId
		LEFT OUTER JOIN
	country T11 ON T11.id = T10.countryId
		LEFT OUTER JOIN
	country_region T12 ON T12.id = T10.countryRegionId
WHERE
   T2.id IN 
   (
      namedParams
   )",
    `jsonString` ='{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "emailId",
            "resultKey": "EMAIL_ID",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "mobileNumber",
            "resultKey": "MOBILE_NO",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "mobile Code",
            "resultKey": "MOBILE_CODE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "Login Id",
            "resultKey": "LOGIN_ID",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "Password",
            "resultKey": "PASSWORD",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
}' WHERE (`dataProviderId` = @dtproviderId);
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20200821214523__Update_sqldtproviderSendOfferLetter () $$
DROP PROCEDURE IF EXISTS V20200821214523__Update_sqldtproviderSendOfferLetter $$
DELIMITER ;