DELIMITER $$
DROP PROCEDURE IF EXISTS V20200827090858__Insert_reportTemplate $$
CREATE PROCEDURE V20200827090858__Insert_reportTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'CAST_CATEGORY_REPORT')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('10', 'CAST_CATEGORY_REPORT', 'Caste Category & Religion Wise Subject Grades Report', 'CAST_CATEGORY_REPORT.png', 'CommonReport_Excel_withoutHeader.jasper', 'All', '1', 'Header_Excel.jasper', 'Footer_Excel.jasper', '1', '1', 'CAST_CATEGORY_REPORT.jasper', 'AcademiaLogo.png');

set @castCategory = (select id from report_template where templateCode ='CAST_CATEGORY_REPORT');

INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@castCategory, 'TRANS_SLF_CHART', 'SLF Chart', '1',now()),
(@castCategory, 'TRANS_SCHOOL_NAME', 'Name of the School: ', '1',now()),
(@castCategory, 'TRANS_TOTAL', 'TOTAL', '1',now()),
(@castCategory, 'TRANS_BOY', 'Boys', '1',now()),
(@castCategory, 'TRANS_GIRL', 'Girls', '1',now()),
(@castCategory, 'TRANS_STD', 'STD: ', '1',now()),
(@castCategory, 'TRANS_DIV', 'DIV: ', '1',now()),
(@castCategory, 'TRANS_CLASS_TEACHER', 'CLASS TEACHER: ', '1',now()),
(@castCategory, 'TRANS_SUBJECT', 'SUBJECT: ', '1',now()),
(@castCategory, 'TRANS_OTHERS', 'Others', '1',now());

END IF; 

END $$
CALL V20200827090858__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20200827090858__Insert_reportTemplate $$
DELIMITER ;