DELIMITER $$
DROP PROCEDURE IF EXISTS V20200827115848__Create_FuelConsumption $$
CREATE PROCEDURE V20200827115848__Create_FuelConsumption()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='trans_vehicle_fuel_consumption')) THEN 
CREATE TABLE `trans_vehicle_fuel_consumption` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `vehicleId` BIGINT(20) NOT NULL,
  `refillDate` DATE NULL,
  `odometerReading` DOUBLE NULL,
  `approximateAvailableFuel` DOUBLE NULL,
  `currentRefill` DOUBLE NULL,
  `totalFuel` DOUBLE NULL,
  `amount` DOUBLE NOT NULL,
  `refillBy` VARCHAR(255) NULL,
  `refillStation` VARCHAR(255) NULL,
  `fuelConsumptionAverage` DOUBLE NULL,
  `lastUpdatedBy` BIGINT(20) NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `trans_vfc_vehicle_idx` (`vehicleId` ASC),
  INDEX `fk_vfc_users_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `trans_vfc_vehicle_id`
    FOREIGN KEY (`vehicleId`)
    REFERENCES `trans_vehicle` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_vfc_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200827115848__Create_FuelConsumption () $$ 
DROP PROCEDURE IF EXISTS V20200827115848__Create_FuelConsumption $$ 
DELIMITER ;