DELIMITER $$
DROP PROCEDURE IF EXISTS V20200901102057__Create_V2D151522_enquiry_summary_view $$
CREATE PROCEDURE V20200901102057__Create_V2D151522_enquiry_summary_view()
BEGIN


IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'enquiry_summary_view')) THEN 
DROP view `enquiry_summary_view`;
END IF;



IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='enquiry_summary_view')) THEN 
Create Or Replace View enquiry_summary_view as select
 distinct a.code as Lead_Id,a.enquiryDate as Lead_Date,GCon.Source_Of_entry,
adk.code as Student_ID,a.registeredByType as Enquired_By,
a.printName as Parent,
concat(coalesce(b.studentFirstName,'') ,' ',coalesce(b.studentMiddleName,''),' ',coalesce(b.studentLastName,'')) as Student_Name,
b.gender ,b.studentDateOfBirth,a.academyLocationId,c.displayName as Brand_Campus_Name,
c.academyName as Brand_Name ,c.locationName as Campus_Name,e.itemValue as Mode_of_Offering,
case when f.batchPartTime = 1 then 'Part Time' else 'Full Time'  end as Registration_Type ,
d.fieldOfInterest as Field_of_Interest,g.programName as GradeName,g.programShortName as Grade ,
g.programSequence as Grade_Sequence,h.groupName as School_Phase,i.categoryName as Grade_Category,
f.printName as Intake,j.itemValue as Intake_Year,l.seatName as Seat_Type,
m.campaignName as Brand_Campaign_Name,m.presentationType as Presentation_type,
o.itemValue as School,p.printName as Lead_Owner_Name,
case when a.status='O' then 'Open'  when a.status='C' then 'Closed' else null end as Lead_Status ,
q.closureDate as Closure_Date,
DATEDIFF(q.closureDate,a.enquiryDate) as Closed_No_of_Days,r.type as Lead_Stage,
b.id,appl.code as  Application_ID,
s.enquirySource as Lead_point_of_Entry,t.campaignName as Campaign_Name,
u.enquiryTypeName as Enquiry_Type,
w.status as Closure_Reason,  case when w.status in('Already Admitted','Closed Successfully')
then 'Yes' else 'No' end as Closed_Successfully,
(select count(x.enquiryid) as No_of_Follow_Up from enq_followup x where x.enquiryid=a.id) as No_of_Follow_Up
  ,y.priority,ab.countryName as Country
,ac.countryRegionName as Province,ad.cityName as City,
case when b.sibilingUser1 is null and b.sibilingUser2 is null and b.sibilingUser3 is null then 'No' else 'Yes' end as Sibling_Studying_presently_in_the_organisation,
case when a.whetherCompanySponsored=1 then 'Yes'
when a.whetherCompanySponsored =0 then 'No' else null end as Company_Sponsored,
case when b.fatherEmployed=1 then 'Yes'
when b.fatherEmployed =0 then 'No' else null end as Employee_of_Organization

from enquiry a left join enq_student_details b on(a.id=b.enquiryId)
left join admission_enq_details d on(b.id=d.enqStudentDetailsId)
 left join academy_location c on(d.academyLocationId=c.id)
 
 left join mode_of_delivery e on(d.modeOfDeliveryId=e.id)
 left join batches f on(d.batchId=f.id)
 left join programs g on(d.programId=g.id)
 left join program_group h on(g.programGroupId=h.id)
  left join program_category i on(g.programCategoryId=i.id)
 left join intake_year j on(f.intakeYearId=j.id)
 left join prog_batch_seat_config k on(d.progBatchSeatConfigId=k.id)
 left join seat_types l on(k.seatTypeId=l.id)
 left join campaign_new m on(a.campaignId=m.id)
 left join campaign_school_mapping n on(n.campaignNewId=m.id)
 left join campaign_school o on(n.campaignSchoolId=o.id)
 left join users p on(a.userId=p.id) left join
 (select max(kk.closureDate) as closureDate,kk.enquiryId,kk.id from enq_closure_reason kk
 group by kk.enquiryId) q on (q.enquiryId=a.id and a.status='C')
 left join enq_intermediate_type r on(a.enqIntermediateStageId=r.id)
 left join enquiry_source s on(a.enquirySourceId=s.id)
 left join campaign t on(a.campaignId=t.id)
 left join enquiry_type u on(a.enquiryTypeId=u.id)
 left join enq_closure_reason v on(v.enquiryId=a.id)
 left join closure_reason w on(v.closureReasonId=w.id)
 left join enq_priority y on(a.enqPriorityId=y.id)
 left join enq_address z on(a.id=z.enquiryId)
 left join address  aa on(aa.id=z.addressId)
 left join  country ab on(aa.countryId=ab.id)
 left join country_region ac on(aa.countryRegionId=ac.id)
 left join city ad on(aa.cityId=ad.id)
 left join application appl on appl.enquiryStudentDetailId = b.id
 left join application_program ap on ap.applicationId = appl.id
 left join application_admission_detail aad on aad.applicationProgramId = ap.id
 left join admission adk on adk.applicationAdmissionId = aad.id
 left join (select group_concat(em.itemvalue) Source_Of_entry,enqu.code from enquiry enqu ,enquiry_multiple_mode emm,enquiry_mode em
where enqu.id=emm.enquiryId and emm.enquiryModeId=em.id group by enqu.code) GCon
on(a.code=GCon.code);

END IF; 

END $$
CALL V20200901102057__Create_V2D151522_enquiry_summary_view () $$ 
DROP PROCEDURE IF EXISTS V20200901102057__Create_V2D151522_enquiry_summary_view $$ 
DELIMITER ;