DELIMITER $$
DROP PROCEDURE IF EXISTS V20200902110512__Insert_OptInOptOutDateTrans $$
CREATE PROCEDURE V20200902110512__Insert_OptInOptOutDateTrans()
BEGIN

	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'OPT_IN' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','OPT_IN','Opt-In','Opt-In','Chọn tham gia','Aanvaar intekening',now(),1);
	END IF; 
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'OPT_OUT' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','OPT_OUT','Opt-Out','Opt-Out','Chọn không tham gia','Onttrek',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'DATE_OF_JOINING_FROM' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','DATE_OF_JOINING_FROM','Date of Joining From','Date of Joining From','Ngày tham gia từ','Datum van aansluiting vanaf',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'DATE_OF_JOINING_TO' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','DATE_OF_JOINING_TO','Date of Joining To','Date of Joining To','Ngày gia nhập','Datum van aansluiting by',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'EXIT_DATE_FROM' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','EXIT_DATE_FROM','Exit Date From','Exit Date From','Ngày thoát khỏi','Uittreedatum vanaf',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'EXIT_DATE_TO' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','EXIT_DATE_TO','Exit Date To','Exit Date To','Ngày Thoát Đến','Uitgangsdatum tot',now(),1);
	END IF;
	
	IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName = 'DATE_OF_JOINING' and  objectName ='TRANSLATIONS')) THEN 
		INSERT INTO `ui_translation`(`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`vietLanguage`,`afriLanguage`,`lastUpdate`,`lastUpdatedBy`)
		 VALUES ('TRANSLATIONS','DATE_OF_JOINING','Date of Joining','Date of Joining','Ngày tham gia','Datum van aansluiting',now(),1);
	END IF;

END $$
CALL V20200902110512__Insert_OptInOptOutDateTrans() $$
DROP PROCEDURE IF EXISTS V20200902110512__Insert_OptInOptOutDateTrans $$
DELIMITER ;