DELIMITER $$
DROP PROCEDURE IF EXISTS V20200904181345__Insert_AverageReportType $$
CREATE PROCEDURE V20200904181345__Insert_AverageReportType()
BEGIN


IF NOT EXISTS ((SELECT * FROM `report_type` WHERE typeName = 'Average Report')) THEN 
INSERT INTO `report_type` (`typeName`) VALUES ('Average Report'); 
set @reportName = (select id from report_type WHERE typeName = 'Average Report');
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'STUDENT_AVERAGE_REPORT_PROGRAM_WISE' and reportTypeId=@reportName)) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@reportName, 'STUDENT_AVERAGE_REPORT_PROGRAM_WISE', 'Student Average Report by Program', 'STUDENT_AVERAGE_REPORT_PROGRAM_WISE.png', 'CommonReport_Excel.jasper', 'All', '1', 'Footer_Excel_Blank.jasper', 'Footer_Excel_Blank.jasper', '1', '1', 'STUDENT_AVERAGE_REPORT_PROGRAM_WISE.jasper', 'AcademiaLogo.png'); 
END IF; 


IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'STUDENT_AVERAGE_REPORT_COURSE_WISE' and reportTypeId=@reportName)) THEN 
INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@reportName, 'STUDENT_AVERAGE_REPORT_COURSE_WISE', 'Student Average Report by Course  Category', 'STUDENT_AVERAGE_REPORT_COURSE_WISE.png', 'CommonReport_Excel.jasper', 'All', '1', 'Footer_Excel_Blank.jasper', 'Footer_Excel_Blank.jasper', '1', '1', 'STUDENT_AVERAGE_REPORT_COURSE_WISE.jasper', 'AcademiaLogo.png'); 

END IF; 


END $$
CALL V20200904181345__Insert_AverageReportType() $$
DROP PROCEDURE IF EXISTS V20200904181345__Insert_AverageReportType $$
DELIMITER ;
