DELIMITER $$
DROP PROCEDURE IF EXISTS V20200921113933__Insert_D4_Report $$
CREATE PROCEDURE V20200921113933__Insert_D4_Report()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE templateCode = 'D4_ASSESSMENT_REPORT' )) THEN 
set @reportNamed4 = (select id from report_type WHERE typeName = 'Examination Foils Report');

INSERT INTO `report_template` ( `reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 

VALUES (@reportNamed4, 'D4_ASSESSMENT_REPORT', 'D-4 Assessment report', 'D4_ASSESSMENT_REPORT.png', 'D4_CommonReport_PageNumber.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'D4_ASSESSMENT_REPORT.jasper', 'AcademiaLogo.png'); 
END IF;

set @d4ID = (select id from report_template where templateCode ='D4_ASSESSMENT_REPORT');
	
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_END_SEM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_END_SEM', 'END SEMESTER EXAMINATION ASSESSMENT OF PRACTICAL', '1', now());
 END IF;
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_EXT_INT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_EXT_INT', '(External/Internal)', '1', now());
 END IF;
 
  
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_ACADEMIC_YEAR')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_ACADEMIC_YEAR', 'Academic Year:', '1', now());
 END IF;
 
  
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_PROGRAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_PROGRAM', 'Program:', '1', now());
 END IF;
  
  
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_COURSE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_COURSE', 'Course:', '1', now());
 END IF;
  
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_COURSE_CODE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_COURSE_CODE', 'Course Code:', '1', now());
 END IF;
  
 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_SEMESTER')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_SEMESTER', 'Semester:', '1', now());
 END IF;
    

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_FACULTY_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_FACULTY_NAME', 'Name of Faculty:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_MARKS_MAX')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_MARKS_MAX', 'Marks Max.:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_MARKS_MIN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_MARKS_MIN', 'Marks Minimum:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_DATEOF_EXAM')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_DATEOF_EXAM', 'Date of Examination:', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_ENROLLMENT')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_ENROLLMENT', 'Enrolment No.', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_STD_NAME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_STD_NAME', 'Name of Student', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_EXAM_SEATNO')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_EXAM_SEATNO', 'Exam Seat No.', '1', now());
 END IF;

 IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_TE_SCHEME')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_TE_SCHEME', 'Marks obtained in Oral/Practical Exam. As per T.E Scheme', '1', now());
 END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_SIGN_INTERNAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_SIGN_INTERNAL', 'Name & Signature of Internal Examiner', '1', now());
 END IF;


IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_SIGN_EXTERNAL')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_SIGN_EXTERNAL', 'Name & Signature of External Examiner', '1', now());
 END IF;
 
 IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @d4ID and keyValue='TRANS_NOTE')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
VALUES (@d4ID, 'TRANS_NOTE', 'Note - Any fractional marks should be rounded to next integer.', '1', now());
 

END IF;

END $$
CALL V20200921113933__Insert_D4_Report() $$
DROP PROCEDURE IF EXISTS V20200921113933__Insert_D4_Report $$
DELIMITER ;
