DELIMITER $$
DROP PROCEDURE IF EXISTS V20200925113234__Create_Exam_Cancellation $$
CREATE PROCEDURE V20200925113234__Create_Exam_Cancellation()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='exam_cancellation' )) THEN 
CREATE TABLE `exam_cancellation` (
  `id` BIGINT NOT NULL AUTO_INCREMENT,
  `examCancellationName` VARCHAR(255) NOT NULL,
  `maximumCourse` BIGINT NOT NULL,
  `status` VARCHAR(100) NOT NULL,
  `autoApprove` BIT(1) NULL DEFAULT b'0',
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `examCancellation_lastUpdateBy` (`lastUpdatedBy` ASC) ,
  CONSTRAINT `exam_cancellation_lastUpdatedBy`
	FOREIGN KEY (`lastUpdatedBy`)
	REFERENCES `users` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20200925113234__Create_Exam_Cancellation () $$ 
DROP PROCEDURE IF EXISTS V20200925113234__Create_Exam_Cancellation $$ 
DELIMITER ;