DELIMITER $$
DROP PROCEDURE IF EXISTS V20200925165346__Insert_Exam_Cancellation_Translation_UI $$
CREATE PROCEDURE V20200925165346__Insert_Exam_Cancellation_Translation_UI()
BEGIN

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='AUTO_APPROVE_EXAM_CANCELLATION_REQUEST' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','AUTO_APPROVE_EXAM_CANCELLATION_REQUEST','Auto Approve Exam Cancellation Request','Auto Approve Exam Cancellation Request',
	'Versoek om kansellasie van eksamen outomaties goed te keur', 'Tự động phê duyệt yêu cầu hủy bài kiểm tra',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='EXAM_CANCELLATION_NAME' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','EXAM_CANCELLATION_NAME','Exam Cancellation Name','Exam Cancellation Name',
	'Eksamen Kansellasie Naam', 'Tên hủy bài kiểm tra',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='EXAM_CANCELLATION_NAME' and objectName='EXAMINATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('EXAMINATION','EXAM_CANCELLATION_NAME','Exam Cancellation Name','Exam Cancellation Name',
	'Eksamen Kansellasie Naam', 'Tên hủy bài kiểm tra',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='LIST_OF_EXAM_CANCELLATION' and objectName='TRANSLATIONS')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('TRANSLATIONS','LIST_OF_EXAM_CANCELLATION','List of Exam Cancellation','List of Exam Cancellation',
	'Lys van eksamenkansellasie', 'Danh sách hủy bài kiểm tra',now(),1);
END IF; 


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='ADD_EXAM_CANCELLATION_DETAILS' and objectName='EXAMINATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('EXAMINATION','ADD_EXAM_CANCELLATION_DETAILS','Add Exam Cancellation Details','Add Exam Cancellation Details',
	'Voeg eksamenkansellasiebesonderhede by', 'Thêm chi tiết hủy bài kiểm tra',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='EDIT_EXAM_CANCELLATION_DETAILS' and objectName='EXAMINATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('EXAMINATION','EDIT_EXAM_CANCELLATION_DETAILS','Edit Exam Cancellation Details','Edit Exam Cancellation Details',
	'Wysig eksamenkansellasiebesonderhede', 'Chỉnh sửa chi tiết hủy bài kiểm tra',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='EXAM_CANCELLATION_ALREADY_MAPPED_MSG' and objectName='EXAMINATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('EXAMINATION','EXAM_CANCELLATION_ALREADY_MAPPED_MSG','Exam Cancellation is already mapped with selected program batches.','Exam Cancellation is already mapped with selected program batches.',
	'Eksamenkansellasie is reeds gekarteer met geselekteerde programgroepe.', 'Hủy bài kiểm tra đã được ánh xạ với các lô chương trình được chọn.',now(),1);
END IF; 


IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='OTHER_EXAM_CANCELLATION_IS_ALREADY_MAPPED_WITH_THE_FOLLOWING_PROGRAMS_AND_BATCHES' and objectName='EXAMINATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('EXAMINATION','OTHER_EXAM_CANCELLATION_IS_ALREADY_MAPPED_WITH_THE_FOLLOWING_PROGRAMS_AND_BATCHES','Other exam cancellation is already mapped with the following programs and batches<br />',
	'Other exam cancellation is already mapped with the following programs and batches<br />',
	'Ander eksamenkansellasies word reeds met die volgende programme en groepe gekarteer<br />', 'Việc hủy bỏ kỳ thi khác đã được lập bản đồ với các chương trình và lô sau<br />',now(),1);
END IF; 

IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE keyName ='DO_YOU_STILL_WANT_TO_MAP_THE_EXAM_CANCELLATION' and objectName='EXAMINATION')) THEN 
INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`, `lastUpdate`,`lastUpdatedBy`) 
	VALUES ('EXAMINATION','DO_YOU_STILL_WANT_TO_MAP_THE_EXAM_CANCELLATION','Do you still want to map the exam cancellation with the selected programs and batches?',
	'Do you still want to map the exam cancellation with the selected programs and batches?',
	'Wil u die eksamenkansellasie nog steeds in kaart bring met die geselekteerde programme en groepe?',
	'Bạn vẫn muốn lập bản đồ hủy bài thi với các chương trình và đợt đã chọn?',now(),1);
END IF; 

END $$
CALL V20200925165346__Insert_Exam_Cancellation_Translation_UI() $$
DROP PROCEDURE IF EXISTS V20200925165346__Insert_Exam_Cancellation_Translation_UI $$
DELIMITER ;