DELIMITER $$

DROP PROCEDURE IF EXISTS V20201006203640__CreateMaritalStatus $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20201006203640__CreateMaritalStatus()

BEGIN
  
  IF NOT EXISTS ((SELECT * FROM information_schema.Columns WHERE table_schema=DATABASE() AND table_name='marital_status' )) THEN
  
  CREATE TABLE `marital_status` (
		  `id` bigint(20) NOT NULL AUTO_INCREMENT,
		  `itemCode` varchar(255) NOT NULL,
		  `itemValue` varchar(255) NOT NULL,
		  `isDeletable` BIT(1) NOT NULL DEFAULT 1,
		  `isEditable` BIT(1) NOT NULL DEFAULT 1,
		  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
		  `lastUpdatedBy` bigint(20) NOT NULL,
		  PRIMARY KEY (`id`),
		  UNIQUE KEY `itemCode_UNIQUE` (`itemCode`),
		  UNIQUE KEY `itemValue_UNIQUE` (`itemValue`),
		  KEY `fk_marital_status_lastUpdatedBy_idx` (`lastUpdatedBy`),
		  CONSTRAINT `fk_marital_status_lastUpdatedBy` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
		  ON DELETE NO ACTION
		  ON UPDATE NO ACTION
		) ENGINE=InnoDB DEFAULT CHARSET=utf8;


		INSERT INTO marital_status (itemCode,itemValue, isDeletable, isEditable, lastUpdate, lastUpdatedBy)  VALUES ('DIVORCED','Divorced', 0, 0, now(),1);
		INSERT INTO marital_status (itemCode,itemValue, isDeletable, isEditable, lastUpdate, lastUpdatedBy)  VALUES ('WIDOWER','Widower', 0, 0, now(),1);
		INSERT INTO marital_status (itemCode,itemValue, isDeletable, isEditable, lastUpdate, lastUpdatedBy)  VALUES ('SEPARATED','Separated', 0, 0, now(),1);

		
		 SET @standardMasterMaxId=(SELECT MAX(id) FROM standard_master);
		 INSERT INTO `standard_master`(`id`,`childMaster`,`tableName`,`masterName`,`moduleName`,`filterCode`,`whetherChild`,`whetherParent`, `droolsAgenda`,`lastUpdatedBy`,`lastUpdate`) 
		 VALUES (@standardMasterMaxId+1, NULL,'marital_status','MARITAL_STATUS','General Setup','COMMON_MASTER',0,0,NULL,1,SYSDATE());

		 SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		 INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		 VALUES (@ItemsMaxId+1, 'code', 'ITEM_CODE', @standardMasterMaxId+1, 'varchar', '1', 0, 0, 0, 0, '1', SYSDATE());
		 SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		 INSERT INTO standard_master_items(`id`, `dbFieldName`, `fieldLabel`, `standardMasterId`, `fieldType`, `diaplayOrder`, `whetherForeignKey`, `whetherShortCode`, `whetherReadOnly`, `wheherNullable`, `lastUpdatedBy`, `lastUpdate`) 
		 VALUES (@ItemsMaxId+1, 'value', 'ITEM_VALUE', @standardMasterMaxId+1, 'varchar', '2', 0, 0, 0, 0, '1', SYSDATE());
		 SET @ItemsMaxId=(SELECT MAX(id) FROM standard_master_items);
		 
		 

  END IF;
  
  -- insert ui translation for CSM dropdown value
	 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='masterNames' and keyName='MARITAL_STATUS')) THEN

		INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`) 
		VALUES ('masterNames','MARITAL_STATUS','Marital Status','Marital Status','Huwelikstatus','Tình trạng hôn nhân',now(),1);

  END IF;

END $$

-- Execute the stored procedure
CALL V20201006203640__CreateMaritalStatus() $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20201006203640__CreateMaritalStatus $$
 
DELIMITER ;
