DELIMITER $$
DROP PROCEDURE IF EXISTS V20201008154945__CreateGuidelinesDocForSignup $$
CREATE PROCEDURE V20201008154945__CreateGuidelinesDocForSignup()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='signup_setup_document')) THEN 
CREATE TABLE `signup_setup_document` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `document_id` bigint(20) NOT NULL,
  `signup_setup_id` bigint(20) NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_signup_setup_document` (`document_id`),
  KEY `FK_signup_additional_setup` (`signup_setup_id`),
  KEY `FK_signup_setup_document_users` (`lastUpdatedBy`),
  CONSTRAINT `FK_signup_additional_setup` FOREIGN KEY (`signup_setup_id`) REFERENCES `signup_additional_setup` (`id`),
  CONSTRAINT `FK_signup_setup_document_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201008154945__CreateGuidelinesDocForSignup () $$ 
DROP PROCEDURE IF EXISTS V20201008154945__CreateGuidelinesDocForSignup $$ 
DELIMITER ;