DELIMITER $$
DROP PROCEDURE IF EXISTS V20201015173310__CreateIsPortalLinkSaved $$
CREATE PROCEDURE V20201015173310__CreateIsPortalLinkSaved()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='portal_setup_saved_link')) THEN 
CREATE TABLE `portal_setup_saved_link` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `application_id` bigint(20) NOT NULL,
  `setup_id` bigint(20) NULL DEFAULT NULL,
  `module_id` bigint(20) NULL DEFAULT NULL,
  `is_filled` TINYINT(1) NULL DEFAULT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `FK_portal_setup_saved_link_application_id` (`application_id`),
  KEY `FK_portal_setup_saved_link_setup_id` (`setup_id`),
  KEY `FK_portal_setup_saved_link_module_id` (`module_id`),
  KEY `FK_portal_setup_saved_link_lastUpdatedBy` (`lastUpdatedBy`),
  CONSTRAINT `FK_portal_setup_saved_link_application` FOREIGN KEY (`application_id`) REFERENCES `application` (`id`),
  CONSTRAINT `FK_portal_setup_saved_link_applicant_portal_setup` FOREIGN KEY (`setup_id`) REFERENCES `applicant_portal_setup` (`id`),
  CONSTRAINT `FK_portal_setup_saved_link_applicant_portal_modules` FOREIGN KEY (`module_id`) REFERENCES `applicant_portal_modules` (`id`),
  CONSTRAINT `FK_portal_setup_saved_link_users` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201015173310__CreateIsPortalLinkSaved () $$ 
DROP PROCEDURE IF EXISTS V20201015173310__CreateIsPortalLinkSaved $$ 
DELIMITER ;