DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_persondetails //
CREATE  PROCEDURE sp_tvet_persondetails()
BEGIN

select per.nationalID as National_Id
,iddetail.idNumber as Person_Alternate_Id
,iddetail.itemCode as Alternate_Id_Type_Id
,castc.itemCode as Equity_Code
,nation.itemCode as Nationality_Code
,dropd.name as Home_Language_Code
,per.gender as Gender_Code,
case when per.isLearnerSACitizen=1 then 'SA'  when 0 then 'Asylum or Refugee'  else 'U' end as Citizen_Resident_Status_Code,
'' as Filler01,
dropdisable.value as Disability_Status_Code
,per.lastName as Person_Last_Name
,per.firstName as Person_First_Name
,per.middleName as Person_Middle_Name
,sal.salutationName as Person_Title
,per.birthDate as Person_Birth_Date,
addr.addressText as Person_Home_Address_1
,ct1.cityName as Person_Home_Address_2,
cnt1.countryName as Person_Home_Address_3,
addr2.addressText as  Person_Postal_Address_1
,ct2.cityName as Person_Postal_Address_2,
cnt2.countryName as Person_Postal_Address_3,
addr.pincode as Person_Home_Addr_Postal_Code,
addr2.pincode as Person_Postal_Addr_Post_Code,
concat(concat(per.phoneCountryCode,' ',per.phoneAreaCode),' ',per.phoneNo) as Person_Phone_Number
,concat(per.mobileCountryCode,' ',per.mobileNumber) as Person_Cell_Phone_Number,
'' as Person_Fax_Number
,per.emailId as Person_Email_Address,
cr1.code as Province_Code
,loc.shortCode as Provider_Code,
541 as Provider_ETQE_Id,
iddetailmin.lastname as Person_Previous_Lastname,
iddetailmin.idNumber as Person_Previous_Alternate_Id,
iddetailmin.itemCode as Person_Previous_Alternate_Id_Type_Id
,
'' as Person_Previous_Provider_Code
,541 as Person_Previous_Provider_ETQE_Id,

case when dropdown.type like '%Seeing%' then dropdown.value else null end Seeing_Rating_Id,
case when dropdown.type like '%Hearing%' then dropdown.value else null end Hearing_Rating_Id,
case when dropdown.type like '%Walking%' then dropdown.value else null end Walking_Rating_Id,
case when dropdown.type like '%Remembering%' then dropdown.value else null end Remembering_Rating_Id,
case when dropdown.type like '%Communicating%' then dropdown.value else null end Communicating_Rating_Id,
case when dropdown.type like '%Self Care%' then dropdown.value else null end Self_Care_Rating_Id,

per.isMilitarySponsored as POPI_Act_Status_ID,
adm.admissionDate as POPI_Act_Status_Date,
DATE_FORMAT(NOW(), '%Y%m%d') AS Date_Stamp
from 
program_batch_students progbatchstu inner join admission adm 
on(progbatchstu.admissionid=adm.id)
inner join students stu on(adm.studentId=stu.userid)
inner join users usr on(usr.id=stu.userid)
join persons per on(stu.personId=per.id)
left join drop_down dropdisable on(per.haveDisabilities=dropdisable.id)
left join batches batch on(progbatchstu.programBatchId =batch.id)
left join programs prog on(batch.programId=prog.id)
left join academy_location al on(al.id=prog.academyLocationId)
left join locations loc on(al.locationId=loc.id) 
left join salutations sal on(sal.id=per.salutationId)
left join 
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode from(
select idNumber,personId,idt.itemCode,row_number() OVER (PARTITION by personId order by isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')) iddtla where iddtla.rn=1)
iddetail on(iddetail.personId=per.id)
left join caste_categories castc on(castc.id=per.castCategoryId)
left join nationalities nation on(nation.id=per.nationalityId)
left join drop_down dropd on(dropd.id=per.homelanguage)
left join person_addresses peradd on(per.id=peradd.personId)
left join (select add1.* from address add1 left join address_type addty1 
on(add1.addressTypeId=addty1.id and addty1.addressTypeName='Current' and addty1.addressCategory='PERSON')) addr
on(addr.id=peradd.addressId)
left join city ct1 on(addr.cityId=ct1.id)
left join country_region cr1 on(addr.countryRegionId=cr1.id) 
left join country cnt1 on(addr.countryId=cnt1.id)
left join (select add1.* from address add1 left join address_type addty1 
on(add1.addressTypeId=addty1.id and addty1.addressTypeName='Correspondance' and addty1.addressCategory='PERSON')) addr2
on(addr2.id=peradd.addressId )
left join city ct2 on(addr2.cityId=ct2.id)
left join country cnt2 on(addr2.countryId=cnt2.id)
left join non_academic_achievements nonacad on(nonacad.person_id=per.id)
left join drop_down dropdown on(dropdown.id=nonacad.levelEventId)
left join 
(select iddtla.idNumber,iddtla.personId,iddtla.itemCode,iddtla.lastName from(
select idNumber,personId,idt.itemCode,per1.lastName,row_number() OVER (PARTITION BY personId ORDER BY isnull(validTillDate) desc,validTillDate desc) rn
from identity_detail iddet join identity_type idt on(iddet.idType=idt.id and idt.itemCode='Passport')
left join persons per1 on(per1.id=iddet.personId)
) iddtla where iddtla.rn=2) iddetailmin on(per.id=iddetailmin.personId)
group by progbatchstu.id;

END//
DELIMITER ;