DELIMITER $$
DROP PROCEDURE IF EXISTS V20201029122853__Update_sqldtproviderAppointment $$
CREATE PROCEDURE V20201029122853__Update_sqldtproviderAppointment()
BEGIN
SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT');
IF EXISTS ((select * from sql_dtprovider where dataProviderId = @dtproviderId)) THEN 
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
	(Case
        when T3.code is null then enq.code
        else T3.code
    end) as ENQ_CODE,
    T1.appointeeName AS PRINT_NAME,
    T1.appointeeEmailId AS EMAIL_ID,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', 1)) AS MOBILE_CODE,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', - 1)) AS MOBILE_NO,
    TRIM(SUBSTRING_INDEX(appointeeName, '/', - 1)) AS FIRST_NAME,
	T2.academyName AS ACADEMY_NAME,
    T2.locationName AS LOCATION_NAME,
    T2.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T5.addressText,' ',T6.cityName,', ',T7.countryName,', ',T8.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
	CONCAT(T5.phoneCountryCode,'-',T5.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
	T5.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    (CASE
        WHEN T10.printName IS NULL THEN T9.printName
        ELSE T10.printName
    END) AS LEAD_OWNER_NAME,
    (CASE
        WHEN T14.emailId IS NULL THEN T12.emailId
        ELSE T14.emailId
    END) AS OWNER_EMAIL_ID,
    (CASE
        WHEN T14.mobileNumber IS NULL THEN CONCAT(T12.mobileCountryCode,
            ' ',
            T12.mobileNumber)
        ELSE CONCAT(T14.mobileCountryCode,
            ' ',
            T14.mobileNumber)
    END) AS OWNER_MOBILE_NO,
    (Case 
    when T2.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T2.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T2.logoUrl)end) as LOGO_URL,
    (Case when T2.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.headerUrl) 
    else NULL end) as HEADER_URL,
	(Case when T2.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T2.footerUrl) 
    else NULL end) as FOOTER_URL
FROM
    sg_appointment T1
        LEFT JOIN
    academy_location T2 ON T2.id = T1.academyLocationId
		LEFT JOIN
    application T3 ON T3.id = T1.applicationId
   		LEFT JOIN
    organizations org on org.id = 1
		LEFT JOIN
    enquiry enq on enq.id = T1.enquiryId
		LEFT JOIN
	academy_location_addresses T4 ON T4.academyLocationId = T2.id
		LEFT OUTER JOIN
	address T5 ON T5.id = T4.addressId && T5.addressTypeId=10
		LEFT OUTER JOIN
	city T6 ON T6.id = T5.cityId
		LEFT OUTER JOIN
	country T7 ON T7.id = T6.countryId
		LEFT OUTER JOIN
	country_region T8 ON T8.id = T6.countryRegionId
		LEFT OUTER JOIN
	users T9 ON T9.id = enq.assignedToUserId
		LEFT JOIN
    staffs T11 ON T11.userId = T9.id
        LEFT JOIN
    persons T12 ON T12.id = T11.personId
		LEFT JOIN
	users T10 ON T10.id=T3.applicationOwner
		LEFT JOIN
    staffs T13 ON T13.userId = T10.id
        LEFT JOIN
    persons T14 ON T14.id = T13.personId
	WHERE
    T1.id IN (namedParams) group by id",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "id",
            "resultKey": "ID",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "visitTime",
            "resultKey": "VISIT_TIME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "FIRST_NAME",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "PERSON_TO_MEET",
            "resultKey": "PERSON_TO_MEET",
            "displayCode": "",
            "displayOrder": 3
        },        
        {
            "id": 5,
            "value": "appointeeName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 4
        },        
        {
            "id": 6,
            "value": "APPOINTMENT_DATE",
            "resultKey": "APPOINTMENT_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
		{
            "id": 11,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
        {
            "id": 13,
            "value": "Academy Location Address",
            "resultKey": "ACADEMY_LOCATION_ADDRESS",
            "displayCode": "",
            "displayOrder": 12
        },
        {
            "id": 14,
            "value": "Academy Location Phone No.",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 13
        },
        {
            "id": 15,
            "value": "Academy Location Email Id",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 14
        },
        {
            "id": 16,
            "value": "Owner Name",
            "resultKey": "OWNER_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "code",
            "resultKey": "ENQ_CODE",
            "displayCode": "",
            "displayOrder": 16
        },
        {
            "id": 18,
            "value": "Lead Owner Name",
            "resultKey": "LEAD_OWNER_NAME",
            "displayCode": "",
            "displayOrder": 17
        },
        {
            "id": 19,
            "value": "Owner EmailId",
            "resultKey": "OWNER_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 18
        },
        {
            "id": 20,
            "value": "Owner Mobile No",
            "resultKey": "OWNER_MOBILE_NO",
            "displayCode": "",
            "displayOrder": 19
        }
    ]
}' WHERE `dataProviderId` = @dtproviderId;
END IF; 
SET SQL_SAFE_UPDATES=1;
END $$
CALL V20201029122853__Update_sqldtproviderAppointment () $$
DROP PROCEDURE IF EXISTS V20201029122853__Update_sqldtproviderAppointment $$
DELIMITER ;