DELIMITER $$
DROP PROCEDURE IF EXISTS V20201105174750__Create_sales_leads_target_view $$
CREATE PROCEDURE V20201105174750__Create_sales_leads_target_view()
BEGIN

IF EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_leads_target_view')) THEN 
DROP view `sales_leads_target_view`;
END IF; 


IF NOT EXISTS ((SELECT VIEW_DEFINITION FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_SCHEMA =database() AND TABLE_NAME = 'sales_leads_target_view')) THEN 
CREATE OR REPLACE view sales_leads_target_view as

select managetarget.academyLocationId,managetarget.academyName,managetarget.academyCode,
managetarget.locationName,managetarget.locationCode,
managetarget.intake_year,managetarget.Target_For,sum(managetarget.Total_Target),
sum(enqdata.cnt) as total_actual_leads,Staff_Owner
from (
select manage.academyLocationId,al.academyName,al.academyCode,al.locationName,locationCode
,ir.itemValue as intake_year, manageTargetType as Target_For,
manage.actualTarget as Total_Target,usr.printName as Staff_Owner,staffId,manage.intakeYearId
from academy_location al
left join manage_target_tertiary manage on(manage.academyLocationId=al.id and manageTargetType='ENQUIRY')
left join intake_year ir on(manage.intakeYearId=ir.id)
left join users usr on(staffId=usr.id)
group by academyName,locationCode,manageTargetType,staffId
) managetarget left join
(select
count(distinct this_.id) as cnt,this_.userId,intakeyear5_.id as intakeYearId
,academyloc3_.id as academyLocationId
from enquiry this_
left outer join
enq_student_details enquirystu1_
on this_.id=enquirystu1_.enquiryId
left outer join
admission_enq_details admissione2_
on enquirystu1_.id=admissione2_.enqStudentDetailsId
left outer join
academy_location academyloc3_
on admissione2_.academyLocationId=academyloc3_.id
left outer join
batches batch4_
on admissione2_.batchId=batch4_.id
left outer join
intake_year intakeyear5_
on batch4_.intakeYearId=intakeyear5_.id
where this_.whetherDeleted=false
group by
this_.userId,intakeyear5_.id,academyloc3_.id) enqdata

on(managetarget.intakeYearId= enqdata.intakeYearId and
managetarget.academyLocationId=enqdata.academyLocationId
and managetarget.staffId=enqdata.userId)
group by managetarget.academyName,managetarget.locationCode,managetarget.Target_For,staffId;
END IF; 

END $$
CALL V20201105174750__Create_sales_leads_target_view () $$ 
DROP PROCEDURE IF EXISTS V20201105174750__Create_sales_leads_target_view $$ 
DELIMITER ;