DELIMITER $$
DROP PROCEDURE IF EXISTS V20201106122332__Create_disciplinaryanctionDocumentsSU $$
CREATE PROCEDURE V20201106122332__Create_disciplinaryanctionDocumentsSU()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='disciplinary_action_su_documents')) THEN 
CREATE TABLE `disciplinary_action_su_documents` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `documentId` bigint DEFAULT NULL,
  `disciplinaryActionId` bigint DEFAULT NULL,
  `lastUpdate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdatedBy` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_disc_act_su_doc_idx` (`documentId`),
  KEY `fk_disc_act_doc_disc_idx` (`disciplinaryActionId`),
  KEY `fk_disc_su_doc_last_update_idx` (`lastUpdatedBy`),
  CONSTRAINT `fk_disc_act_doc_disc_su` FOREIGN KEY (`disciplinaryActionId`) REFERENCES `disciplinary_actions_su` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_disc_act_su_doc` FOREIGN KEY (`documentId`) REFERENCES `documents` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT,
  CONSTRAINT `fk_disc_su_doc_last_update` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`) ON DELETE RESTRICT ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

END IF; 

END $$
CALL V20201106122332__Create_disciplinaryanctionDocumentsSU () $$ 
DROP PROCEDURE IF EXISTS V20201106122332__Create_disciplinaryanctionDocumentsSU $$ 
DELIMITER ;