DELIMITER //

DROP PROCEDURE IF EXISTS sp_tvet_staffclassesdetails //

CREATE  PROCEDURE sp_tvet_staffclassesdetails()
BEGIN
select 
    per.externalSysRefOne as Staff_Number,
    cour.courseCode as Subject_Code,
    '' as Unit_Standard_Id,
    yearweek(cousec.sessionDate) as Year_Week_Id,
    sum(timestampdiff(hour, slotFrom, slotTo)) as Teaching_Hours,
    loc.shortCode as Provider_Code,
    541 as Provider_ETQE_Id,
    date_format(now(), '%Y%m%d') as Date_Stamp
from
    course_coverage_plan cousec
        join
    staffs staf on (cousec.facultyId = staf.userId)
        join
    academy_location al on (cousec.academyLocationId = al.id)
        join
    locations loc on (al.locationId = loc.id)
        join
    course_variants cv on (cv.id = cousec.courseVariantId)
        join
    courses cour on (cour.id = cv.courseId)
        join
    persons per on (per.id = staf.personId)
group by cousec.facultyId , cour.id , yearweek(cousec.sessionDate)
;
END//
DELIMITER ;