DELIMITER $$
DROP PROCEDURE IF EXISTS V20201210103357__Create_AcademyLocationContacts $$
CREATE PROCEDURE V20201210103357__Create_AcademyLocationContacts()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='academy_location_contacts')) THEN 
CREATE TABLE `academy_location_contacts` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `academyLocationId` BIGINT(20) NOT NULL,
  `contactName` VARCHAR(255) NULL,
  `designation` VARCHAR(255) NULL,
  `addressId` BIGINT(20) NULL,
  `lastUpdatedBy` BIGINT(20) NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_al_contact_al_id_idx` (`academyLocationId` ASC),
  INDEX `fk_al_contact_address_id_idx` (`addressId` ASC),
  INDEX `fk_al_contact_last_update_by_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_al_contact_al_id`
    FOREIGN KEY (`academyLocationId`)
    REFERENCES `academy_location` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_al_contact_address_id`
    FOREIGN KEY (`addressId`)
    REFERENCES `address` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_al_contact_last_update_by_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20201210103357__Create_AcademyLocationContacts () $$ 
DROP PROCEDURE IF EXISTS V20201210103357__Create_AcademyLocationContacts $$ 
DELIMITER ;