DELIMITER $$
DROP PROCEDURE IF EXISTS V20201216211356__Create_VoterPoolExternalUser $$
CREATE PROCEDURE V20201216211356__Create_VoterPoolExternalUser()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='voter_pool_external_user')) THEN 
CREATE TABLE `voter_pool_external_user` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(255) NOT NULL,
  `phoneCountryCode` VARCHAR(10) NULL,
  `phoneNumber` VARCHAR(20) NULL,
  `emailId` VARCHAR(255) NULL,
  `description` TEXT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_vpeu_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_vpeu_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

END IF; 

END $$
CALL V20201216211356__Create_VoterPoolExternalUser () $$ 
DROP PROCEDURE IF EXISTS V20201216211356__Create_VoterPoolExternalUser $$ 
DELIMITER ;