DELIMITER $$
DROP PROCEDURE IF EXISTS V20201218184521__Create_CampaignSchoolContectsDetail $$
CREATE PROCEDURE V20201218184521__Create_CampaignSchoolContectsDetail()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='campaign_school_contact_details')) THEN 
CREATE TABLE `campaign_school_contact_details`(
`id` BIGINT(20) NOT NULL AUTO_INCREMENT,
`campaign_school_id` BIGINT(20) NOT NULL,
`contact_details` VARCHAR(500) NULL DEFAULT NULL,
`name` VARCHAR(500) NULL DEFAULT NULL,
`email_address` VARCHAR(500) NULL DEFAULT NULL,
`telephone_country_code` VARCHAR(10) NULL DEFAULT NULL,
`telephone_number` VARCHAR(15) NULL DEFAULT NULL,
`lastUpdatedBy` BIGINT(20) NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,

PRIMARY KEY (`id`),
    KEY `fk_campaign_school_details_campaign_school` (`campaign_school_id`),
     KEY `camp_school_contact_details_lastUpdatedBy` (`lastUpdatedBy`),

CONSTRAINT `fk_campaign_school_details_campaign_school`
  FOREIGN KEY (`campaign_school_id`)
  REFERENCES `campaign_school` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION,

CONSTRAINT `camp_school_contact_details_lastUpdatedBy`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`));
END IF; 

END $$
CALL V20201218184521__Create_CampaignSchoolContectsDetail () $$ 
DROP PROCEDURE IF EXISTS V20201218184521__Create_CampaignSchoolContectsDetail $$ 
DELIMITER ;