DELIMITER $$
DROP PROCEDURE IF EXISTS V20201231161014__Create_thesis_management $$
CREATE PROCEDURE V20201231161014__Create_thesis_management()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='thesis_management')) THEN 
CREATE TABLE `thesis_management` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
    `periodId` BIGINT(20) NOT NULL,
    `admissionId` BIGINT(20) NOT NULL,
    `graduationCeremonyId` BIGINT(20) DEFAULT NULL,
    `thesisManagementDroolId` BIGINT(20) DEFAULT NULL,
	`remarks` VARCHAR(1000) DEFAULT NULL,
	`status` VARCHAR(100) NOT NULL,
	`lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    INDEX `fk_thesis_management_prog_batch_period_config_idx` (`periodId` ASC),
	CONSTRAINT `fk_thesis_management_prog_batch_period_config`
    FOREIGN KEY (`periodId`)
    REFERENCES `prog_batch_period_config` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    INDEX `fk_thesis_management_admission_idx` (`admissionId` ASC),
	CONSTRAINT `fk_thesis_management_admission`
    FOREIGN KEY (`admissionId`)
    REFERENCES `admission` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    INDEX `fk_thesis_management_graduation_ceremony_idx` (`graduationCeremonyId` ASC),
	CONSTRAINT `fk_thesis_management_graduation_ceremony`
    FOREIGN KEY (`graduationCeremonyId`)
    REFERENCES `graduation_ceremony` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
    INDEX `fk_thesis_management_drool_rules_idx` (`thesisManagementDroolId` ASC),
	CONSTRAINT `fk_thesis_management_drool_rules`
    FOREIGN KEY (`thesisManagementDroolId`)
    REFERENCES `drool_rules` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201231161014__Create_thesis_management () $$ 
DROP PROCEDURE IF EXISTS V20201231161014__Create_thesis_management $$ 
DELIMITER ;