DELIMITER $$
DROP PROCEDURE IF EXISTS V20201231162130__Create_thesis_management_supervisor $$
CREATE PROCEDURE V20201231162130__Create_thesis_management_supervisor()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE()  AND table_name='thesis_management_supervisor')) THEN 
CREATE TABLE `thesis_management_supervisor` (
	`id` BIGINT(20) NOT NULL AUTO_INCREMENT, 
    `thesisManagementId` BIGINT(20) NOT NULL,
    `supervisorId` BIGINT(20) NOT NULL,
    `lastUpdatedBy` BIGINT(20) NOT NULL,
	`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	PRIMARY KEY (`id`),
    INDEX `fk_thesis_management_supervisor_thesis_management_idx` (`thesisManagementId` ASC),
	CONSTRAINT `thesis_management_supervisor_thesis_management`
    FOREIGN KEY (`thesisManagementId`)
    REFERENCES `thesis_management` (`id`)
    ON DELETE RESTRICT
    ON UPDATE RESTRICT,
    INDEX `fk_thesis_management_supervisor_users_idx` (`supervisorId` ASC),
	CONSTRAINT `fk_thesis_management_supervisor_users`
    FOREIGN KEY (`supervisorId`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
	FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
END IF; 

END $$
CALL V20201231162130__Create_thesis_management_supervisor () $$ 
DROP PROCEDURE IF EXISTS V20201231162130__Create_thesis_management_supervisor $$ 
DELIMITER ;