DELIMITER $$

DROP PROCEDURE IF EXISTS V20210202184255__AlterSelectionProcessStage $$

-- Create the stored procedure to perform the migration
CREATE PROCEDURE V20210202184255__AlterSelectionProcessStage()

BEGIN
  
  -- Add the column to the table, if it doesn't already exist
  IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='program_slctn_process_stages' 
  AND column_name='droolBatchMappingId')) THEN
  
    -- ALTER TABLE QUERY;
    ALTER TABLE `program_slctn_process_stages` ADD COLUMN `droolBatchMappingId` BIGINT(20) NULL after `batchSlot`;

	set foreign_key_checks=0;
	ALTER TABLE `program_slctn_process_stages` 
	ADD CONSTRAINT `fk_droolBatchMappingId`
	FOREIGN KEY (`droolBatchMappingId`)
	REFERENCES `drool_batch_mapping` (`id`)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	set foreign_key_checks=1;
  
  END IF;

END $$

-- Execute the stored procedure
CALL V20210202184255__AlterSelectionProcessStage $$

-- Don't forget to drop the stored procedure when you're done!
DROP PROCEDURE IF EXISTS V20210202184255__AlterSelectionProcessStage $$
 
DELIMITER ;