DELIMITER $$
DROP PROCEDURE IF EXISTS V20210223135400__Insert_reportTemplate $$
CREATE PROCEDURE V20210223135400__Insert_reportTemplate()
BEGIN

IF EXISTS (select max(id) from report_type where typeName='Student Assessment Reports') THEN
set  @reportTypeId = (select max(id) from report_type where typeName='Student Assessment Reports');

IF NOT EXISTS (select * from report_template where `templateCode`='ACADEMIC_PROGRESS_REPORT_PDF') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeId, 'ACADEMIC_PROGRESS_REPORT_PDF', 'Academic Progress Report Pdf', 'ACADEMIC_PROGRESS_REPORT_PDF.png', 'CommonReport_LandScape.jasper', 'All', '1', 'FooterBlank.jasper', 'FooterBlank.jasper', '1', '1', 'ACADEMIC_PROGRESS_REPORT_PDF.jasper', 'AcademiaLogo.png');
END IF;

IF NOT EXISTS (select * from report_template where `templateCode`='ACADEMIC_PROGRESS_REPORT_EXCEL') THEN
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
VALUES (@reportTypeId, 'ACADEMIC_PROGRESS_REPORT_EXCEL', 'Academic Progress Report Excel', 'ACADEMIC_PROGRESS_REPORT_EXCEL.png', 'CommonReport_Excel_withoutHeader.jasper', 'All', '1', 'Header_Excel_Blank.jasper', 'Header_Excel_Blank.jasper', '1', '1', 'ACADEMIC_PROGRESS_REPORT_EXCEL.jasper', 'AcademiaLogo.png');
END IF;

END IF;

END $$
CALL V20210223135400__Insert_reportTemplate() $$
DROP PROCEDURE IF EXISTS V20210223135400__Insert_reportTemplate $$
DELIMITER  ;