DELIMITER $$
DROP PROCEDURE IF EXISTS V20210323171514__Create_ManageHoldCategory $$
CREATE PROCEDURE V20210323171514__Create_ManageHoldCategory()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='manage_hold_category')) THEN 
CREATE TABLE `manage_hold_category` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `holdCatCode` VARCHAR(255) DEFAULT NULL,
  `holdCatName` VARCHAR(255) DEFAULT NULL,
  `isActive` BIT(1) DEFAULT NULL,
  `lastUpdatedBy` BIGINT NOT NULL,
  `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  INDEX `fk_hold_category_users_id_idx` (`lastUpdatedBy` ASC),
  CONSTRAINT `fk_hold_category_users_id`
    FOREIGN KEY (`lastUpdatedBy`)
    REFERENCES `users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);
END IF; 

END $$
CALL V20210323171514__Create_ManageHoldCategory () $$ 
DROP PROCEDURE IF EXISTS V20210323171514__Create_ManageHoldCategory $$ 
DELIMITER ;