DELIMITER $$

DROP PROCEDURE IF EXISTS V20210330155838__Alter_WMSFileInfoAddColumns $$

CREATE PROCEDURE V20210330155838__Alter_WMSFileInfoAddColumns()

BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='lastUpdate')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='lastUpdatedBy')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `lastUpdatedBy` BIGINT NULL DEFAULT NULL;

  ALTER TABLE `wms_file_info` 
	ADD CONSTRAINT `fk_wms_file_info_lastUpdatedBy`
  FOREIGN KEY (`lastUpdatedBy`)
  REFERENCES `users` (`id`)
  ON DELETE NO ACTION
  ON UPDATE NO ACTION;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='fileName')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `fileName` VARCHAR(255) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='exceptionFileName')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `exceptionFileName` VARCHAR(255) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='reportFileName')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `reportFileName` VARCHAR(255) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='exceptionFilesFound')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `exceptionFilesFound` bit(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='reportFilesFound')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `reportFilesFound` bit(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='readExceptionFilesStatus')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `readExceptionFilesStatus` bit(1) NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='exceptionFileLastMDate')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `exceptionFileLastMDate` TIMESTAMP NULL DEFAULT NULL;
END IF;

IF NOT EXISTS ((SELECT * FROM information_schema.columns WHERE table_schema=DATABASE() AND table_name='wms_file_info' AND column_name='reportFileLastMDate')) THEN 
  ALTER TABLE `wms_file_info` 
  ADD COLUMN `reportFileLastMDate` TIMESTAMP NULL DEFAULT NULL;
END IF;

END $$

CALL V20210330155838__Alter_WMSFileInfoAddColumns() $$

DROP PROCEDURE IF EXISTS V20210330155838__Alter_WMSFileInfoAddColumns $$

DELIMITER ;