DELIMITER $$
DROP PROCEDURE IF EXISTS V20210518122409__Insert_PatentDetailsDataGridConfig $$
CREATE PROCEDURE V20210518122409__Insert_PatentDetailsDataGridConfig()
BEGIN

IF NOT EXISTS ((SELECT * FROM data_grid WHERE gridName="Academia.view.personinfo.common.pasthistory.PatentDetailsGrid" AND portalId=1)) THEN 
	INSERT INTO `data_grid`(`gridName`,`portalId`,`jsonObject`,`lastUpdate`,`lastUpdatedBy`) VALUES
	('Academia.view.personinfo.common.pasthistory.PatentDetailsGrid',1,
	'[{"id":null,"columnName":"PATENT_TYPE","dataIndex":"patentTypeSM","columnVisibility":"SHOW","sequence":1,"mandatory":true},
	{"id":null,"columnName":"PATENT_NAME","dataIndex":"patentName","columnVisibility":"SHOW","sequence":2,"mandatory":true},
	{"id":null,"columnName":"DATE_OF_PATENT_FILED","dataIndex":"dateOfPatentFiled","columnVisibility":"SHOW","sequence":3,"mandatory":false},
	{"id":null,"columnName":"DATE_OF_PATENT_AWARDED","dataIndex":"dateOfPatentAwarded","columnVisibility":"SHOW","sequence":4,"mandatory":false},
	{"id":null,"columnName":"DOCUMENT","dataIndex":"noOfdocument","columnVisibility":"SHOW","sequence":5,"mandatory":false},
	{"id":null,"columnName":"PATENT_OTHER_DETAILS","dataIndex":"otherDetails","columnVisibility":"HIDE","sequence":6,"mandatory":false},
	{"id":null,"columnName":"MAPPED_SUPERVISORS","dataIndex":"supervisorId","columnVisibility":"HIDE","sequence":7,"mandatory":false},
	{"id":null,"columnName":"DEFENCE_DATE","dataIndex":"defenceDate","columnVisibility":"HIDE","sequence":8,"mandatory":false}]',now(),1);
END IF; 

END $$
CALL V20210518122409__Insert_PatentDetailsDataGridConfig() $$
DROP PROCEDURE IF EXISTS V20210518122409__Insert_PatentDetailsDataGridConfig $$
DELIMITER ;