DELIMITER $$
DROP PROCEDURE IF EXISTS V20210603200402__Insert_StudentIDCARDTemp_GNA $$
CREATE PROCEDURE V20210603200402__Insert_StudentIDCARDTemp_GNA()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'STUDENT_ID_CARD_GNA')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
	VALUES ('7', 'STUDENT_ID_CARD_GNA', 'Student ID Card - GNA', 'STUDENT_ID_CARD_GNA.png', 'CommonReport_IdCard_Vertical_ATM_GNACardSize.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'STUDENT_ID_CARD_GNA.jasper', 'AcademiaLogo.png');

END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='STUDENT_ID_CARD_GNA'))) THEN
    
	set @studentIDCard = (select id from report_template where templateCode ='STUDENT_ID_CARD_GNA');
	 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@studentIDCard, 'TRANS_REGD_NO', 'REGD. NO', '1', NOW()),
	(@studentIDCard, 'TRANS_STUDENT_NAME', 'NAME', '1', NOW()),
	(@studentIDCard, 'TRANS_FATHERS_NAME', 'FATHERS NAME', '1', NOW()),
    (@studentIDCard, 'TRANS_DOB', 'DATE OF BIRTH', '1', NOW()),
    (@studentIDCard, 'TRANS_BATCH', 'BATCH', '1', NOW()),
    (@studentIDCard, 'TRANS_PROGRAM', 'PROGRAM', '1', NOW()),
    (@studentIDCard, 'TRANS_BLOOD_GROUP', 'BLOOD GROUP', '1', NOW()),
    (@studentIDCard, 'TRANS_INSTRUCTIONS', 'Instructions:', '1', NOW()),
    (@studentIDCard, 'TRANS_FIRSTPOINT', '1. The Card should be displayed at all time while you are in university campus.', '1', NOW()),
    (@studentIDCard, 'TRANS_SECONDPOINT', '2. In case of loss, inform the loss of card to the university administration.', '1', NOW()),
    (@studentIDCard, 'TRANS_ISSUING_AUTHORITY', 'Issuing Authority', '1', NOW()),
    (@studentIDCard, 'TRANS_FOUND_RETURN', 'If found please return to:', '1', NOW()),
    (@studentIDCard, 'TRANS_CONTACT_NO', 'Contact No:', '1', NOW());

  END IF;
END $$
CALL V20210603200402__Insert_StudentIDCARDTemp_GNA() $$
DROP PROCEDURE IF EXISTS V20210603200402__Insert_StudentIDCARDTemp_GNA $$
DELIMITER ;