DELIMITER $$
DROP PROCEDURE IF EXISTS V20210604161025__Insert_EmployeeIdCardForAEFV2 $$
CREATE PROCEDURE V20210604161025__Insert_EmployeeIdCardForAEFV2()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'AEF-V2_Employee_ID_Card')) THEN 
 INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`)
 VALUES ('13', 'AEF-V2_Employee_ID_Card', 'AEF-V2 Employee ID Card', 'AEF-V2_Employee_ID_Card.png', 'CommonReport_IdCard_Vertical_UGI.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '1', '1', 'AEF-V2_Employee_ID_Card.jasper', 'AcademiaLogo.png');

END IF; 

set @AEF_V2_Employee_ID_Card = (select max(id) from report_template where templateCode ='AEF-V2_Employee_ID_Card');

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId= @AEF_V2_Employee_ID_Card and keyValue='TRANS_AUTHORIZED_SIGN')) THEN
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@AEF_V2_Employee_ID_Card, 'TRANS_AUTHORIZED_SIGN', 'Authorized sign:', '1', NOW());
END IF;
END $$
CALL V20210604161025__Insert_EmployeeIdCardForAEFV2() $$
DROP PROCEDURE IF EXISTS V20210604161025__Insert_EmployeeIdCardForAEFV2 $$
DELIMITER ;