DELIMITER $$
DROP PROCEDURE IF EXISTS V20210608173523__Insert_AEI_StudentIDCardTemplate $$
CREATE PROCEDURE V20210608173523__Insert_AEI_StudentIDCardTemplate()
BEGIN

IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'AEI_STUDENT_ID_CARD')) THEN 
INSERT INTO `report_template` (`reportTypeId`, `templateCode`, `templateName`, `imageLocation`, `jasperFileLocation`, `documentTypes`, `whetherDefault`, `headerJasperFileLocation`, `footerJasperFileLocation`, `repeatHeaderOnAllPages`, `repeatFooterOnAllPages`, `bodyJasperFileLocation`, `defaultHeaderLogo`) 
VALUES ('7', 'AEI_STUDENT_ID_CARD', 'AEI Student ID Card', 'AEI_STUDENT_ID_CARD.png', 'CommonReport_IdCard_Vertical_AEI.jasper', 'All', '1', 'FooterBlank_IdCard.jasper', 'FooterBlank_IdCard.jasper', '0', '0', 'AEI_STUDENT_ID_CARD.jasper', 'AcademiaLogo.png');
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE `reportTemplateId` = (select id from report_template where templateCode ='AEI_STUDENT_ID_CARD'))) THEN
   
	set @studentIDCard = (select id from report_template where templateCode ='AEI_STUDENT_ID_CARD');
	 
    INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`) 
	VALUES (@studentIDCard, 'TRANS_IDENTITY_CARD', 'IDENTITY CARD', '1', NOW()),
    (@studentIDCard, 'TRANS_DOB', 'DOB:', '1', NOW()),
    (@studentIDCard, 'TRANS_ADDRESS', 'ADDRESS:', '1', NOW()),
    (@studentIDCard, 'TRANS_CELL', 'Cell:', '1', NOW()),
    (@studentIDCard, 'TRANS_SECRETARY', 'SECRETARY', '1', NOW()),
    (@studentIDCard, 'TRANS_SONOF', 'C/o.', '1', NOW()),
    (@studentIDCard, 'TRANS_SIGN', '(Dr. G.VIJAYARAGAVAN)', '1', NOW());

  END IF;

END $$
CALL V20210608173523__Insert_AEI_StudentIDCardTemplate() $$
DROP PROCEDURE IF EXISTS V20210608173523__Insert_AEI_StudentIDCardTemplate $$
DELIMITER ;