DELIMITER $$
DROP PROCEDURE IF EXISTS V20210719150315__Alter_course_view $$
CREATE PROCEDURE V20210719150315__Alter_course_view()
BEGIN
DROP VIEW IF EXISTS `course_view`;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='course_view')) THEN 
CREATE 
    ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `course_view` AS
    SELECT 
        `cou`.`courseName` AS `Name`,
        `cou`.`courseCode` AS `Code`,
        `dept`.`deptName` AS `DepartmentName`,
        `dept`.`shortCode` AS `DepartmentCode`,
        `cou`.`courseCredits` AS `Credit`,
        `cou`.`courseCodeToBePrinted` AS `Code_to_printed`,
        `cou`.`nameToBePrinted` AS `nameToBePrinted`
    FROM
        (`courses` `cou`
        JOIN `department` `dept` ON ((`dept`.`id` = `cou`.`departmentId`)));
END IF; 

END $$
CALL V20210719150315__Alter_course_view() $$
DROP PROCEDURE IF EXISTS V20210719150315__Alter_course_view $$
DELIMITER ;