DELIMITER $$
DROP PROCEDURE IF EXISTS V20210813171013__Create_FeePlanPersonsCoveredDeleted $$
CREATE PROCEDURE V20210813171013__Create_FeePlanPersonsCoveredDeleted()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='fee_plan_persons_covered_deleted')) THEN 

	CREATE TABLE `fee_plan_persons_covered_deleted` (
  `id` bigint NOT NULL AUTO_INCREMENT primary key,
  `feePlanRuleId` bigint NOT NULL,
  `userId` bigint DEFAULT NULL,
  `applicantId` bigint DEFAULT NULL,
  `studentId` bigint DEFAULT NULL,
  `joinDate` date DEFAULT NULL,
  `lastUpdatedBy` bigint NOT NULL,
  `lastUpdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  CONSTRAINT FOREIGN KEY (`feePlanRuleId`) REFERENCES `fee_plan_rules` (`id`),
  CONSTRAINT FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users` (`id`),
  CONSTRAINT FOREIGN KEY (`studentId`) REFERENCES `students` (`userId`));
	
END IF; 

END $$
CALL V20210813171013__Create_FeePlanPersonsCoveredDeleted () $$ 
DROP PROCEDURE IF EXISTS V20210813171013__Create_FeePlanPersonsCoveredDeleted $$ 
DELIMITER ;