DELIMITER $$
DROP PROCEDURE IF EXISTS V20210910180329__Create_address_view $$
CREATE PROCEDURE V20210910180329__Create_address_view()
BEGIN
DROP VIEW IF EXISTS address_view;
IF NOT EXISTS ((SELECT * FROM information_schema.views WHERE table_schema=DATABASE() AND table_name='address_view')) THEN 
CREATE 
     OR REPLACE ALGORITHM = UNDEFINED 
    DEFINER = `ss_root`@`%` 
    SQL SECURITY DEFINER
VIEW `address_view` AS
    SELECT 
        `data`.`code` AS `code`,
        `data`.`suNumber` AS `suNumber`,
        `data`.`Relationship Type` AS `Relationship Type`,
        `data`.`addressTypeName` AS `addressTypeName`,
        `data`.`addressLine1` AS `addressLine1`,
        `data`.`addressLine2` AS `addressLine2`,
        `data`.`suburb` AS `suburb`,
        `data`.`city` AS `city`,
        `data`.`countryName` AS `countryName`,
        `data`.`province` AS `province`,
        `data`.`postalCode` AS `postalCode`
    FROM
        (SELECT DISTINCT
            `appl`.`code` AS `code`,
                `ap`.`externalSysRefOne` AS `suNumber`,
                'Own Address' AS `Relationship Type`,
                `at`.`addressTypeName` AS `addressTypeName`,
                `aa`.`addressText` AS `addressLine1`,
                '' AS `addressLine2`,
                `aac`.`cf1` AS `suburb`,
                `ct`.`cityName` AS `city`,
                `cnt`.`countryName` AS `countryName`,
                `cr`.`countryRegionName` AS `province`,
                `aa`.`pincode` AS `postalCode`
        FROM
            ((((((((`application` `appl`
        LEFT JOIN `applicant_person` `ap` ON ((`appl`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `applicant_person_relationships` `apr` ON ((`apr`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `applicant_address` `aa` ON ((`apr`.`applicantPersonId` = `aa`.`applicantPersonId`)))
        LEFT JOIN `address_type` `at` ON ((`aa`.`addressTypeId` = `at`.`id`)))
        LEFT JOIN `city` `ct` ON ((`ct`.`id` = `aa`.`cityId`)))
        LEFT JOIN `country` `cnt` ON ((`cnt`.`id` = `aa`.`countryId`)))
        LEFT JOIN `applicant_address_cd` `aac` ON ((`aac`.`applicantAddressId` = `aa`.`id`)))
        LEFT JOIN `country_region` `cr` ON ((`cr`.`id` = `ct`.`countryRegionId`)))
        WHERE
            (`at`.`id` IS NOT NULL) UNION SELECT DISTINCT
            `appl`.`code` AS `code`,
                `ap`.`externalSysRefOne` AS `suNumber`,
                CONCAT(`apr`.`relationship`, ' Address') AS `Relationship Type`,
                `at`.`addressTypeName` AS `addressTypeName`,
                `aa`.`addressText` AS `addressLine1`,
                '' AS `addressLine2`,
                `aac`.`cf1` AS `suburb`,
                `ct`.`cityName` AS `city`,
                `cnt`.`countryName` AS `countryName`,
                `cr`.`countryRegionName` AS `province`,
                `aa`.`pincode` AS `postalCode`
        FROM
        
            (((((((((`application` `appl`
        LEFT JOIN `applicant_person` `ap` ON ((`appl`.`applicantPersonId` = `ap`.`id`)))
        LEFT JOIN `applicant_person_relationships` `apr` ON (((`apr`.`applicantPersonId` = `ap`.`id`)
            AND (`apr`.`whetherDeleted` = FALSE))))
        LEFT JOIN `applicant_person` `parent` ON ((`apr`.`relatedApplicantPersonId` = `parent`.`id`)))
        LEFT JOIN `applicant_address` `aa` ON ((`parent`.`id` = `aa`.`applicantPersonId`)))
        LEFT JOIN `address_type` `at` ON ((`aa`.`addressTypeId` = `at`.`id`)))
        LEFT JOIN `city` `ct` ON ((`ct`.`id` = `aa`.`cityId`)))
        LEFT JOIN `country` `cnt` ON ((`cnt`.`id` = `aa`.`countryId`)))
        LEFT JOIN `applicant_address_cd` `aac` ON ((`aac`.`applicantAddressId` = `aa`.`id`)))
        LEFT JOIN `country_region` `cr` ON ((`cr`.`id` = `ct`.`countryRegionId`)))
        WHERE
            (`at`.`id` IS NOT NULL)) `data`
    ORDER BY `data`.`code`;

END IF; 

END $$
CALL V20210910180329__Create_address_view () $$ 
DROP PROCEDURE IF EXISTS V20210910180329__Create_address_view $$ 
DELIMITER ;