DELIMITER //
DROP PROCEDURE IF EXISTS sp_tvet_staffclassesdetails //
CREATE DEFINER=`ss_root`@`%` PROCEDURE `sp_tvet_staffclassesdetails`(in p_alid varchar(1000), in intakeYearId BIGINT)
BEGIN

select 
    usr.code as Staff_Number,
    '' as Unit_Standard_Id,
    cour.courseCode as Subject_Code,
    yearweek(cousec.sessionDate) as Year_Week_Id,
    case when sum(timestampdiff(hour, slotFrom, slotTo)) < 1 then 1 else sum(timestampdiff(hour, slotFrom, slotTo)) end as Teaching_Hours,
    loc.shortCode as Provider_Code,
    541 as Provider_ETQE_Id,
    date_format(now(), '%Y%m%d') as Date_Stamp
from
    course_coverage_plan cousec
        join
    staffs staf on (cousec.facultyId = staf.userId)
    join users usr on(usr.id=staf.userId)
        join
    academy_location al on (cousec.academyLocationId = al.id)
        join
    locations loc on (al.locationId = loc.id)
        join
    course_variants cv on (cv.id = cousec.courseVariantId)
        join
    courses cour on (cour.id = cv.courseId)
        join
    persons per on (per.id = staf.personId)  where FIND_IN_SET( al.id,p_alid)
group by cousec.facultyId , cour.id , yearweek(cousec.sessionDate);

END//
DELIMITER ;