DELIMITER $$
DROP PROCEDURE IF EXISTS V20220714122906__Update_DIT_FFCBCS_GRADE $$
CREATE PROCEDURE V20220714122906__Update_DIT_FFCBCS_GRADE()
BEGIN
SET SQL_SAFE_UPDATES=0;
set @tempID = (select max(id) from report_template where templateCode='DIT_FFCBCS_PROVISIONAL_GRADE_CARD' and templateName='DIT FFCBCS Provisional Grade Card');

IF EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_ENROLL_NO') THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'Student ID' WHERE reportTemplateId = @tempID AND keyValue='TRANS_ENROLL_NO';
END IF;

IF EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_CUMULATIVE_POINTS_USED_IN_CGPA') THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'Cumulative points used in cgpa' WHERE reportTemplateId = @tempID AND keyValue='TRANS_CUMULATIVE_POINTS_USED_IN_CGPA';
END IF;

IF EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_CREDITS_USED_IN_CALCULATING_CGPA') THEN 
UPDATE `report_template_translations` SET `defaultValue` = 'Credits used in calculating cgpa' WHERE reportTemplateId = @tempID AND keyValue='TRANS_CREDITS_USED_IN_CALCULATING_CGPA';
END IF;
SET SQL_SAFE_UPDATES=1;


IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_CUMULATIVE_EARNED_CREDITS_UPTO') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempID, 'TRANS_CUMULATIVE_EARNED_CREDITS_UPTO', 'Cumulative earned credits upto', '1', now());
END IF;

IF NOT EXISTS (SELECT * FROM report_template_translations WHERE reportTemplateId = @tempID AND keyValue='TRANS_BATCH') THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
	VALUES (@tempID, 'TRANS_BATCH', 'Batch', '1', now());
END IF;

END $$
CALL V20220714122906__Update_DIT_FFCBCS_GRADE () $$
DROP PROCEDURE IF EXISTS V20220714122906__Update_DIT_FFCBCS_GRADE $$
DELIMITER ;