DELIMITER $$
DROP PROCEDURE IF EXISTS V20220720104300__Insert_ConfigureLoaderBulkOfferStatus $$
CREATE PROCEDURE V20220720104300__Insert_ConfigureLoaderBulkOfferStatus()
BEGIN

IF NOT EXISTS ((SELECT * FROM `import_utility_master` WHERE screenName = 'Bulk Offer Status Update' and  code ='bulkOfferStatusUpdate')) THEN 
INSERT INTO import_utility_master (screenName, fileDirectory, code, lastUpdatedBy) 
VALUES ('Bulk Offer Status Update', 'admission/offerstatus', 'bulkOfferStatusUpdate', '1');

END IF; 

SET @importUtilityMasterId=(SELECT id FROM import_utility_master where code='bulkOfferStatusUpdate');

#-------------------------Is School------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='ACADEMY_LOCATION_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '1', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='PROGRAM_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PROGRAM_HEADER', 'Program', 'Program', '1', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='BATCH_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('BATCH_HEADER', 'Batch', 'Batch', '1', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='SEAT_TYPE_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SEAT_TYPE_HEADER', 'Seat Type', 'Seat Type', '1', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='APPLICATION_ID_APPLICATION_NAME_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('APPLICATION_ID_APPLICATION_NAME_HEADER', 'Application ID/Applicant name', 'Application ID/Applicant name', '1', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='CURRENT_OFFER_STATUS_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('CURRENT_OFFER_STATUS_HEADER', 'Current Offer status', 'Current Offer status', '1', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='UPDATED_OFFER_STATUS_HEADER' and isSchool='1')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('UPDATED_OFFER_STATUS_HEADER', 'Updated Offer status', 'Updated Offer status', '1', 
now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

#-------------------------Is COLLEGE------------------------------------------------------------------------------------------

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='ACADEMY_LOCATION_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('ACADEMY_LOCATION_HEADER', 'Academy Location', 'Academy Location', '0', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='PROGRAM_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('PROGRAM_HEADER', 'Program', 'Program', '0', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='BATCH_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('BATCH_HEADER', 'Batch', 'Batch', '0', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='SEAT_TYPE_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('SEAT_TYPE_HEADER', 'Seat Type', 'Seat Type', '0', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='APPLICATION_ID_APPLICATION_NAME_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('APPLICATION_ID_APPLICATION_NAME_HEADER', 'Application ID/Applicant name', 'Application ID/Applicant name', '0', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='CURRENT_OFFER_STATUS_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('CURRENT_OFFER_STATUS_HEADER', 'Current Offer status', 'Current Offer status', '0', 
now(), '1', '1', '1', @importUtilityMasterId, '1', NULL);
END IF;

IF NOT EXISTS ((SELECT * FROM `loader_header` WHERE  importUtilityMasterId=@importUtilityMasterId and 
headerCode='UPDATED_OFFER_STATUS_HEADER' and isSchool='0')) THEN 
INSERT INTO loader_header (`headerCode`, `defaultHeaderLabel`, `headerLabel`, `isSchool`, `lastUpdate`, `lastUpdatedBy`,
`isNonEditable`, `isMandatory`, `importUtilityMasterId`, `isVisible`, `defaultValue`)
VALUES ('UPDATED_OFFER_STATUS_HEADER', 'Updated Offer status', 'Updated Offer status', '0', 
now(), '1', '0', '0', @importUtilityMasterId, '1', NULL);
END IF;

END $$
CALL V20220720104300__Insert_ConfigureLoaderBulkOfferStatus() $$
DROP PROCEDURE IF EXISTS V20220720104300__Insert_ConfigureLoaderBulkOfferStatus $$
DELIMITER ;