DELIMITER $$
DROP PROCEDURE IF EXISTS V20220727021914__Insert_RejectAdmissionEventBuzz $$
CREATE PROCEDURE V20220727021914__Insert_RejectAdmissionEventBuzz()
BEGIN

IF NOT EXISTS ((select id from `system_msg_event` where code='REJECT_ADMISSION_NEW')) THEN 
SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='ADMISSION');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'REJECT_ADMISSION_NEW');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='REJECT_ADMISSION_NEW');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'REJECT_ADMISSION_NEW', 'Reject Admission New', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Reject Admission New','Reject Admission New');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1  , @sysmsgevtdefaultconfId+1, @msgScopeParamId);



SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'REJECT_ADMISSION_NEW_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'REJECT_ADMISSION_NEW_RECIPIENT', 'SQL');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_ADMISSION_NEW_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'REJECT_ADMISSION_NEW_RECIPIENT');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_ADMISSION_NEW_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='REJECT_ADMISSION_NEW_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_ADMISSION_NEW_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,"SELECT T1.id as USER_ID,T1.progBatchSeatConfigId as DLS_PROGRAM_BATCH_SEAT_CONFIG_ID FROM 
application_program T1 INNER JOIN `prog_batch_seat_config` T3 ON T3.id = T1.`progBatchSeatConfigId` WHERE T1.id IN (namedParams)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_ADMISSION_NEW_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"select T4.id AS ID,
 	T1.`code` AS APPLICATION_ID,
 	T2.`firstName` AS FIRST_NAME,
 	T2.`lastName` AS LAST_NAME,
 	T2.`emailId` AS EMAIL_ID,
 	T2.`mobileNumber` AS MOBILE_NO,
     T5.displayName AS ACADEMY_LOCATION_NAME,
     T5.academyName AS ACADEMY_NAME,
     T5.locationName AS LOCATION_NAME,
     T5.academyCode AS ACADEMY_ID,
     T1.applicationCreatedOn AS APPLICATION_DATE,
     CONCAT(T7.phoneCountryCode,'-',T7.phoneAreaCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
     T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
     T11.programName AS PROGRAM_NAME,
     T13.batchName AS INTAKE,
     T18.seatName AS SEAT_TYPE,
 	ml.`code` AS LANGUAGE_KEY,
         (CASE
         WHEN
             T5.headerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.headerUrl)
         ELSE NULL
     END) AS HEADER_URL,
     (CASE
         WHEN
             T5.footerUrl IS NOT NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl, '/', T5.footerUrl)
         ELSE NULL
     END) AS FOOTER_URL,
     (CASE
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NOT NULL
         THEN
             CONCAT(org.orgUrl,
                     '/',
                     'emailer/images/logo_default_image.png')
         WHEN
             T5.logoUrl IS NULL
                 AND org.orgUrl IS NULL
         THEN
             'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
         ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
     END) AS LOGO_URL,
         (CASE
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'APPLIED'
         THEN
             'Applied'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'NOT_APPLIED'
         THEN
             'Not Applied'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'SOLD'
         THEN
             'Sold'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'SUBMITTED'
         THEN
             'Submitted'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'APPROVED'
         THEN
             'Approved'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'REJECTED'
         THEN
             'Rejected'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'WITHDRAWN'
         THEN
             'Withdrawn'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'CLOSED'
         THEN
             'Closed'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'DIRECT_ADMISSION'
         THEN
             'Direct Admission'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'MID_TERM_ADMISSION'
         THEN
             'Mid term admission'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'DIRECT_SUBMISSION_TOKEN_GENERATED'
         THEN
             'Direct submission token generated'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'FORM_SALE_TOKEN_GENERATED'
         THEN
             'Form sale token generated'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'NOT_SUBMITTED'
         THEN
             'Not Submitted'
         WHEN
             T1.currentStatus IS NOT NULL
                 AND T1.currentStatus = 'ADMISSION_GRANTED'
         THEN
             'Admission granted'
         ELSE ''
     END) AS APPLICATION_STATUS,
     (CASE
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'OFFER_LETTER_ACCEPTED'
         THEN
             'Offer letter accepted'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'OFFER_LETTER_ISSUED'
         THEN
             'Offer letter issued'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'OFFER_LETTER_REJECTED'
         THEN
             'Offer letter rejected'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'OFFER_LETTER_DUE'
         THEN
             'Offer letter due'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'ACTIVE'
         THEN
             'Active'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'APPROVED'
         THEN
             'Approved'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'ADMITTED'
         THEN
             'Admitted'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'ADMITTED_ON_TRIAL'
         THEN
             'Admitted on trial'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'ADMITTED_ON_PROVISIONAL'
         THEN
             'Admitted on provisional'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'REJECTED'
         THEN
             'Rejected'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'WITHDRAWN'
         THEN
             'Withdrawn'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'WITHDRAW_AFTER_ACCEPTING_OFFER_LETTER'
         THEN
             'Withdrawn after accepting offer letter'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'CLOSED'
         THEN
             'Closed'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'PROVISIONAL_OFFER_ISSUED'
         THEN
             'Provisional offer issued'
             WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'PROVISIONAL_OFFER_REJECTED'
         THEN
             'Provisional offer rejected'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'PROVISIONAL_OFFER_DUE'
         THEN
             'Provisional offer due'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'OFFER_EXPIRED'
         THEN
             'Offer Expired'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'PROVISIONAL_OFFER_EXPIRED'
         THEN
             'Provisional Offer Expired'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'ESCALATED'
         THEN
             'Escalated'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'ESCALATED_OFFER_REVIEWED'
         THEN
             'Escalated Offer Reviewed'
         WHEN
             T4.currentStatus IS NOT NULL
                 AND T4.currentStatus = 'WAITING_LIST'
         THEN
             'Waiting List'  
         ELSE ''
     END) AS OFFER_STATUS,
     T7.websiteURL AS WEBSITE_URL
     from application_program T4
 		left outer join
     application T1 on T4.applicationId = T1.id
 		left outer join
     applicant_person T2 on T1.applicantPersonId=T2.id
 		LEFT OUTER JOIN
     academy_location T5 ON T5.id = T4.academyLocationId
 		LEFT OUTER JOIN
     academy_location_addresses T6 ON T6.academyLocationId = T5.id
 		LEFT OUTER JOIN
     address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
 		LEFT OUTER JOIN
 	city T8 ON T8.id = T7.cityId
 		LEFT OUTER JOIN
 	country T9 ON T9.id = T8.countryId
 		LEFT OUTER JOIN
 	country_region T10 ON T10.id = T8.countryRegionId
 		LEFT OUTER JOIN
 	programs T11 ON T11.id = T4.programId		
 		LEFT JOIN       
     prog_batch_seat_config T17 on T17.id = T4.progBatchSeatConfigId
     LEFT JOIN
 	batches T13 ON T13.programId=T11.id and T13.id = T17.programBatchId
      LEFT JOIN
     seat_types T18 ON T18.id = T17.seatTypeId
      LEFT JOIN
 	users T14 ON T14.id=T1.applicationOwner
 		LEFT JOIN
     staffs T15 ON T15.userId = T14.id
         LEFT JOIN
     persons T16 ON T16.id = T15.personId
 		LEFT JOIN
     multi_language ml ON ml.id = T2.correspondence_language
 		LEFT OUTER JOIN
     organizations org ON org.id = (SELECT 
             MAX(id)
         FROM
             organizations)
     where T4.id in(namedParams)",'{
     "id": 1,
     "searchResultViewColumns": [
         {
             "id": 1,
             "value": "id",
             "resultKey": "ID",
             "displayCode": "",
             "displayOrder": 0
         },
 		{
             "id": 2,
             "value": "code",
             "resultKey": "APPLICATION_ID",
             "displayCode": "",
             "displayOrder": 1
         },
         {
             "id": 3,
             "value": "firstName",
             "resultKey": "FIRST_NAME",
             "displayCode": "",
             "displayOrder": 2
         },
         {
             "id": 4,
             "value": "lastName",
             "resultKey": "LAST_NAME",
             "displayCode": "",
             "displayOrder": 3
         },
 		{
             "id": 5,
             "value": "academyName",
             "resultKey": "ACADEMY_NAME",
             "displayCode": "",
             "displayOrder": 4
         },
 		{
             "id": 6,
             "value": "locationName",
             "resultKey": "LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 5
         },
         {
             "id": 7,
             "value": "displayName",
             "resultKey": "ACADEMY_LOCATION_NAME",
             "displayCode": "",
             "displayOrder": 6
         },
         {
             "id": 8,
             "value": "programName",
             "resultKey": "PROGRAM_NAME",
             "displayCode": "",
             "displayOrder": 7
         },
         {
             "id": 9,
             "value": "batchName",
             "resultKey": "INTAKE",
             "displayCode": "",
             "displayOrder": 8
         },
 		{
             "id": 10,
             "value": "seatName",
             "resultKey": "SEAT_TYPE",
             "displayCode": "",
             "displayOrder": 9
         },
 		{
             "id": 11,
             "value": "APPLICATION_STATUS",
             "resultKey": "APPLICATION_STATUS",
             "displayCode": "",
             "displayOrder": 10
         },
 		{
             "id": 12,
             "value": "OFFER_STATUS",
             "resultKey": "OFFER_STATUS",
             "displayCode": "",
             "displayOrder": 11
         },
 		{
             "id": 13,
             "value": "applicationCreatedOn",
             "resultKey": "APPLICATION_DATE",
             "displayCode": "",
             "displayOrder": 12
         },
 		{
             "id": 14,
             "value": "academyCode",
             "resultKey": "ACADEMY_ID",
             "displayCode": "",
             "displayOrder": 13
         },
         {
             "id": 15,
             "value": "logoUrl",
             "resultKey": "LOGO_URL",
             "displayCode": "",
             "displayOrder": 14
         },
 		 {
             "id": 16,
             "value": "headerUrl",
             "resultKey": "HEADER_URL",
             "displayCode": "",
             "displayOrder": 15
         },
 		 {
             "id": 17,
             "value": "footerUrl",
             "resultKey": "FOOTER_URL",
             "displayCode": "",
             "displayOrder": 16
         },
 		 {
             "id": 18,
             "value": "ACADEMY_LOCATION_PHONE_NO",
             "resultKey": "ACADEMY_LOCATION_PHONE_NO",
             "displayCode": "",
             "displayOrder": 17
         },
 		 {
             "id": 19,
             "value": "primaryeEmailId",
             "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
             "displayCode": "",
             "displayOrder": 18
         },
         {
             "id": 20,
             "value": "websiteURL",
             "resultKey": "WEBSITE_URL",
             "displayCode": "",
             "displayOrder": 19
         }
     ]
 }');


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='REJECT_ADMISSION_NEW');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='REJECT_ADMISSION_NEW');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='REJECT_ADMISSION_NEW_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`,`templatelanguageValue`) 
VALUES(@msgtemplateconfigId+1,'REJECT_ADMISSION_NEW',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Reject Admission New',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1','English');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Letter - Reject Admission','<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0;">
			<td align="center" style="margin:0px; padding:0px;"><img height="150" src="$recipientData[&quot;HEADER_URL&quot;]" width="100%" /></td>
		</tr>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="padding:0px 0px 0px 20px;"><strong>$recipientData[&quot;APPLICATION_ID&quot;]</strong></p>

			<p style="padding:0px 0px 0px 20px;">Dear&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="padding:0px 0px 0px 20px;">Thank you for your application and for your interest to study at The Independent Institute of Education&rsquo;s (The IIE&rsquo;s) $recipientData[&quot;ACADEMY_LOCATION_NAME&quot;]. Regrettably, you have not been accepted to study with us. Your portal will now be deactivated.</p>

			<p style="padding:0px 0px 0px 20px;">Should you wish to change your qualification of choice - please contact the campus. Contact details below.</p>

			<p style="padding:0px 0px 0px 20px;">Kind regards,<br />
			<br />
			<strong>The IIE&#39;s&nbsp;$recipientData[&quot;ACADEMY_LOCATION_NAME&quot;]</strong><br />
			<strong>Email Address:</strong>&nbsp;$recipientData[&quot;ACADEMY_LOCATION_EMAIL_ID&quot;]<br />
			<strong>Phone Number:</strong>&nbsp;$recipientData[&quot;ACADEMY_LOCATION_PHONE_NO&quot;]<br />
			<strong>Website:</strong> $recipientData[&quot;WEBSITE_URL&quot;]</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="margin:0px; padding:0px; background-color:#f0f0f0;"><img height="100" src="$recipientData[&quot;FOOTER_URL&quot;]" width="100%" /></td>
		</tr>
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["FIRST_NAME"] $recipientData["LAST_NAME"], The status pertaining to your studies at The IIEs $recipientData["ACADEMY_LOCATION_NAME"] has changed, please check your emails and action the next steps. Kind Regards, The IIEs $recipientData["ACADEMY_LOCATION_NAME"], Email Address:$recipientData["ACADEMY_LOCATION_EMAIL_ID"], Phone Number:$recipientData["ACADEMY_LOCATION_PHONE_NO"].');


-- Create new document type for this event to map dynamic document

SET @msgtemplateconfigId=(select id from msg_template_config where code='REJECT_ADMISSION_NEW');
SET @dydtdocumenttypeId=(SELECT MAX(id) FROM `dydt_document_type`);
INSERT INTO `dydt_document_type` (`id`,`typeName`, `configLevelCode`, `whetherDeletable`, `typeCode`, `availableForAdhoc`, `whetherEditable`) 
VALUES (@dydtdocumenttypeId+1,'Reject Admission Document', 'PROGRAM_BATCH_SEAT_TYPE_LEVEL', '0', 'REJECT_ADMISSION_NEW', '0', '1');


SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @sysmsgevtrcpntdocId=(SELECT MAX(id) FROM `sys_msg_evt_rcpnt_doc`);
SET @msgscopeparamId=(select id from msg_scope_param where paramKey='DLS_PROGRAM_BATCH_SEAT_CONFIG_ID');
INSERT INTO `sys_msg_evt_rcpnt_doc`(`id`,`sysMsgEvtRcpntDefaultConfigId`,`docTypeId`,`docGenOwnerMappingDef`,`docGenParamMapDef`)
VALUES(@sysmsgevtrcpntdocId+1,@sysmsgevtrcptdefaultconfId,@dydtdocumenttypeId+1,@msgscopeparamId,'[{\"MSG_PARAM\":\"CONTEXT_RECORD_ID\",\"DOC_GEN_PARAM\":\"PRM_APPLICATION_PROGRAM_ID\"}]');

-- Start : Mapping of Dynamic Document to MsgTemplate

SET @msgtemplateconfigdocId=(SELECT MAX(id) FROM `msg_template_config_doc`);
INSERT INTO `msg_template_config_doc` (`id`,`msgTemplateconfigId`, `sysMsgEvtRcpntdocId`) VALUES (@msgtemplateconfigdocId+1,@msgtemplateconfigId,@sysmsgevtrcpntdocId+1);

-- End : Mapping of Dynamic Document to Msgtemplate

SET @dataproviderId=(SELECT MAX(id) FROM `dydt_data_provider`);

INSERT INTO `dydt_data_provider` (`id`,`providerName`,`priority`) values (@dataproviderId+1,'REJECT_ADMISSION_PROVIDER',1);

SET @dydtdocumentdataproviderId=(SELECT MAX(id) FROM `dydt_document_data_provider`);
SET @dydtdataproviderId=(SELECT MAX(id) FROM `dydt_data_provider` where `providerName`='REJECT_ADMISSION_PROVIDER');
INSERT INTO `dydt_document_data_provider` (`id`,`dataProviderId`, `documentTypeId`) VALUES (@dydtdocumentdataproviderId+1,@dydtdataproviderId, @dydtdocumenttypeId+1);

SET @dydtdatalinitemId=(SELECT MAX(id) FROM `dydt_data_line_item`);
INSERT INTO `dydt_data_line_item` (`id`, `dataProviderId`, `dataSourceCode`, `executionOrder`, `publishAsParametersDef`, `whetherDataSource`, `whetherPrimaryDataSource`, `sqlSelectQueryDef`
, `whereClauseBindingDef`, `resultColumnsDef`, `sqlWhereQueryDef`, `whetherMultiRecord`) VALUES (@dydtdatalinitemId+1,@dydtdataproviderId, 'REJECT_ADMISSION_DOCUMENT_INFO', '1',null, '1', '1', 
"SELECT
   CURRENT_DATE() as DOCUMENT_PRINT_DATE,
   T5.firstName AS APPLICANT_FIRST_NAME,
   T5.middleName AS APPLICANT_MIDDLE_NAME,
   T5.lastName AS APPLICANT_LAST_NAME,
   T8.addressText AS APPLICANT_ADDRESS, 
   T9.cityName AS APPLICANT_CITY,
   T8.pincode AS APPLICANT_POSTAL_CODE,
   T10.countryName AS COUNTRY_NAME,
   T7.programCode AS PROGRAM_CODE,
   T7.programName AS PROGRAM_NAME,
   al.displayName AS ACADEMY_NAME_LOCATION,
   ad.primaryeEmailId AS BRAND_CAMPUS_EMAIL,
   CONCAT(ad.phoneCountryCode,'-',ad.phoneAreaCode,'-',ad.phoneNo) AS BRAND_CAMPUS_PHONE_NO,
   T13.itemValue AS INTAKE_YEAR
 	FROM application_program T1
 LEFT JOIN `programs` T7 ON T1.programId = T7.id
 LEFT JOIN
   `prog_batch_seat_config` T11 on T11.id = T1.progBatchSeatConfigId
     LEFT JOIN
 	batches T12 ON T12.programId=T7.id and T12.id = T11.programBatchId
    LEFT JOIN
    intake_year T13 ON T12.intakeYearId=T13.id
LEFT JOIN academy_location al ON T1.academyLocationId=al.id
 	LEFT JOIN academy_location_addresses la ON al.locationId = la.academyLocationId
  LEFT JOIN address ad ON la.addressId = ad.id AND ad.addressTypeId = 10
LEFT JOIN `application` T4 ON T1.applicationId=T4.`id`
 	LEFT JOIN `applicant_person` T5 ON T4.applicantPersonId=T5.id
LEFT JOIN (select add1.* from applicant_address add1 left join address_type addty1
on (add1.addressTypeId=addty1.id and addty1.addressTypeName='Current' and addty1.addressCategory='PERSON'))
T8 on (T8.`applicantPersonId`=T5.`id`)
       LEFT JOIN `city` T9 ON T9.`id`=T8.`cityId`
     LEFT JOIN `country` T10 ON T10.`id`=T8.countryId", 'PRM_APPLICATION_PROGRAM_ID','DOCUMENT_PRINT_DATE,APPLICANT_FIRST_NAME,APPLICANT_MIDDLE_NAME,APPLICANT_LAST_NAME,APPLICANT_ADDRESS,APPLICANT_CITY,APPLICANT_POSTAL_CODE,COUNTRY_NAME,PROGRAM_CODE,PROGRAM_NAME,INTAKE_YEAR,ACADEMY_NAME_LOCATION,BRAND_CAMPUS_EMAIL,BRAND_CAMPUS_PHONE_NO', 'where T1.id=PRM_APPLICATION_PROGRAM_ID;', '0');

   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('DOCUMENT_PRINT_DATE', 'Current Date',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_FIRST_NAME', 'Applicant First Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_MIDDLE_NAME', 'Applicant Middle Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_LAST_NAME', 'Applicant Last Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_ADDRESS', 'Applicant Address',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_CITY', 'Applicant City',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('APPLICANT_POSTAL_CODE', 'Applicant Postal Code',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('COUNTRY_NAME', 'Applicant Country',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_CODE', 'Program Code',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('PROGRAM_NAME', 'Program Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('INTAKE_YEAR', 'Intake Year',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('ACADEMY_NAME_LOCATION', 'Brand Campus Name',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('BRAND_CAMPUS_EMAIL', 'Brand Campus Email',@dydtdatalinitemId);
   INSERT INTO `dydt_templateparams_translations` (`translationCode`, `translationValue`,`dataProviderLineItemId`) VALUES ('BRAND_CAMPUS_PHONE_NO', 'Brand Campus Phone number',@dydtdatalinitemId);
END IF; 

 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='APPLICATION_ID')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','APPLICATION_ID',"Application ID","Application ID","Aansoek ID","ID ứng dụng",now(),1);
 END IF; 

 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='ACADEMY_LOCATION_NAME')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','ACADEMY_LOCATION_NAME',"Academy Location Name","Academy Location Name","Akademie Ligging Naam","Tên địa điểm Học viện",now(),1);
 END IF; 

 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='REJECT_ADMISSION_NEW')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','REJECT_ADMISSION_NEW',"Reject Admission New","Reject Admission New","Verwerp Toelating Nuut","Từ chối Nhập học Mới",now(),1);
 END IF; 
 
 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='REJECT_ADMISSION_NEW_RECIPIENT')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','REJECT_ADMISSION_NEW_RECIPIENT',"Reject Admission New Recipient","Reject Admission New Recipient","Verwerp Toelating Nuwe Ontvanger","Từ chối nhập học Người nhận mới",now(),1);
 END IF; 

 IF NOT EXISTS ((SELECT * FROM `ui_translation` WHERE  objectName='MESSAGING_TRANSLATIONS' and keyName='REJECT_ADMISSION_NEW_DL')) THEN 
 INSERT INTO `ui_translation` (`objectName`,`keyName`,`defaultValue`,`customerDefineValue`,`afriLanguage`,`vietLanguage`,`lastUpdate`,`lastUpdatedBy`)
 VALUES ('MESSAGING_TRANSLATIONS','REJECT_ADMISSION_NEW_DL',"Reject Admission New DL","Reject Admission New DL","Weier Toelating Nuwe DL","Từ chối nhập học DL mới",now(),1);
 END IF; 

END $$
CALL V20220727021914__Insert_RejectAdmissionEventBuzz() $$
DROP PROCEDURE IF EXISTS V20220727021914__Insert_RejectAdmissionEventBuzz $$
DELIMITER ;