DELIMITER $$
DROP PROCEDURE IF EXISTS V20220921155628__Create_LivingArrangementTable $$
CREATE PROCEDURE V20220921155628__Create_LivingArrangementTable()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='living_arrangement')) THEN 
create table living_arrangement(
id bigint(20) NOT NULL AUTO_INCREMENT,livingArrangement bigint(20),roomAllocation varchar(255),address text,startMonth date,
endMonth date,accommodationProviderId bigint(20),cost varchar(50),directPayment tinyint,leaseAgreement varchar(255),
lastUpdate TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,lastUpdatedBy bigint(20) NOT NULL,
 PRIMARY KEY (id),
 CONSTRAINT `living_arrangement_lastUpdatedBy_FK` FOREIGN KEY (lastUpdatedBy) REFERENCES users(id),
 CONSTRAINT `living_arrangement_providerId_FK` FOREIGN KEY (accommodationProviderId) REFERENCES accommodation_provider(id))
  ENGINE=INNODB DEFAULT  CHARSET=utf8;
END IF; 

END $$
CALL V20220921155628__Create_LivingArrangementTable () $$ 
DROP PROCEDURE IF EXISTS V20220921155628__Create_LivingArrangementTable $$ 
DELIMITER ;