DELIMITER $$
DROP PROCEDURE IF EXISTS V20220930153105__Insert_Indus_Staff_Identity_Card $$
CREATE PROCEDURE V20220930153105__Insert_Indus_Staff_Identity_Card()
BEGIN
IF NOT EXISTS ((SELECT * FROM `report_template` WHERE `templateCode` = 'INDUS_STAFF_IDENTITY_CARD')) THEN 
INSERT INTO report_template
(reportTypeId, templateCode, templateName, imageLocation, jasperFileLocation, documentTypes, whetherDefault, headerJasperFileLocation, footerJasperFileLocation, repeatHeaderOnAllPages, repeatFooterOnAllPages, bodyJasperFileLocation, defaultHeaderLogo)
VALUES ( '13', 'INDUS_STAFF_IDENTITY_CARD', 'Indus Staff ID Card', 'id_card_front.png', 'CommonReport_IdCard_Horizontally.jasper', 'All', '1', 'FooterBlank_IdCard_Horizontally.jasper', 'FooterBlank_IdCard_Horizontally.jasper', '1', '1', 'Indus_Staff_ID_Card.jasper', 'AcademiaLogo.png');
END IF; 
set @INDUS_STAFF_IDENTITY_CARD = (select max(id) from report_template where templateCode ='INDUS_STAFF_IDENTITY_CARD');
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='STAFF_IDENTITY_CARD')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'STAFF_IDENTITY_CARD', 'STAFF IDENTITY CARD', '1', NOW());
END IF; 

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='DESIGNATION')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'DESIGNATION', 'Designation', '1', NOW());
END IF; 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='DEPARTMENT')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'DEPARTMENT', 'Department', '1', NOW());
END IF; 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='DOJ')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'DOJ', 'DOJ', '1', NOW());
END IF; 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='BLOOD_GROUP')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'BLOOD_GROUP', 'Blood Grp', '1', NOW());
END IF;
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='REGISTRAR')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'REGISTRAR', 'REGISTRAR', '1', NOW());
END IF; 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='MOB')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'MOB', 'Mob', '1', NOW());
END IF; 
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='EMR_NO')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'EMR_NO', 'Emr. No.', '1', NOW());
END IF;

IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='EMAIL')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'EMAIL', 'Email', '1', NOW());
END IF;
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='ADDRESS')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'ADDRESS', 'Address', '1', NOW());
END IF;
IF NOT EXISTS ((SELECT * FROM `report_template_translations` WHERE  reportTemplateId='INDUS_STAFF_IDENTITY_CARD'  and keyValue='NOTE')) THEN 
INSERT INTO `report_template_translations` (`reportTemplateId`, `keyValue`, `defaultValue`, `lastUpdatedBy`, `lastUpdate`)
Values(@INDUS_STAFF_IDENTITY_CARD, 'NOTE', 'This Card is the Property of Indus University and is not Transferable , Misuse of this card is an offense If found , Please return to the University office.', '1', NOW());
END IF;

END $$
CALL V20220930153105__Insert_Indus_Staff_Identity_Card() $$
DROP PROCEDURE IF EXISTS V20220930153105__Insert_Indus_Staff_Identity_Card $$
DELIMITER ;