DELIMITER $$
DROP PROCEDURE IF EXISTS V20221111194232__Update_OfferLetterConditionDataProvider $$
CREATE PROCEDURE V20221111194232__Update_OfferLetterConditionDataProvider()
BEGIN

SET SQL_SAFE_UPDATES=0;

IF EXISTS ((SELECT * FROM `dydt_data_provider` WHERE providerName='OFFER_LETTER_INFO')) THEN
SET @dataProviderId=(SELECT id FROM `dydt_data_provider` WHERE providerName='OFFER_LETTER_INFO'); 

IF EXISTS ((SELECT * FROM `dydt_data_line_item` WHERE dataSourceCode='APPLICATION_PROGRAM_ADMISSION_DETAILS' AND dataProviderId=@dataProviderId)) THEN
SET @dydtDataLineItemId=(SELECT id FROM `dydt_data_line_item` WHERE dataSourceCode='APPLICATION_PROGRAM_ADMISSION_DETAILS' AND dataProviderId=@dataProviderId); 

UPDATE `dydt_data_line_item` 
	SET sqlSelectQueryDef="SELECT DATE_FORMAT(apd.expiryDate,'%d-%m-%Y') AS offer_valid_until,apad.additionalCondition as additional_condition,
 apad.conditionSatisfactionDate as date_for_satisfaction_condition, 
 group_concat( 
     CASE
     WHEN (acd.additionalCondition IS NOT NULL AND acd.additionalCondition!='' AND acd.conditionSatisfactionDate IS NOT NULL) THEN CONCAT_WS('-',acd.additionalCondition,acd.conditionSatisfactionDate)
     WHEN (acd.additionalCondition IS NOT NULL AND acd.additionalCondition!='') THEN acd.additionalCondition
     END
    SEPARATOR '<br/><br/>') AS additional_condition_text_with_satisfaction_date FROM application_program ap
 LEFT JOIN app_program_adm_details apad ON ap.id=apad.applicationProgramId
 LEFT JOIN application_program_detail apd ON ap.id=apd.applicationProgramId
 LEFT JOIN admission_condition_detail acd ON acd.appProgramAdmDetailsId = apad.id",
	  resultColumnsDef="offer_valid_until,additional_condition,date_for_satisfaction_condition,additional_condition_text_with_satisfaction_date",
sqlWhereQueryDef="WHERE ap.id=PRM_APPLICATION_PROGRAM_ID AND apad.isLatest=1 GROUP BY apd.id ORDER BY acd.id ASC LIMIT 1"
 
	WHERE id=@dydtDataLineItemId;
END IF;

END IF;

SET SQL_SAFE_UPDATES=1;

END $$
CALL V20221111194232__Update_OfferLetterConditionDataProvider() $$
DROP PROCEDURE IF EXISTS V20221111194232__Update_OfferLetterConditionDataProvider $$
DELIMITER ;