DELIMITER $$
DROP PROCEDURE IF EXISTS V20221117171230__Create_NominateExaminers $$
CREATE PROCEDURE V20221117171230__Create_NominateExaminers()
BEGIN

IF NOT EXISTS ((SELECT * FROM information_schema.Tables WHERE table_schema=DATABASE() AND table_name='nominate_examiners')) THEN 
CREATE TABLE `nominate_examiners`(
`id` bigint NOT NULL AUTO_INCREMENT,
`personId` bigint NOT NULL,
`examinerType` bigint(20) DEFAULT NULL,
`examinerName` BIGINT(20) NOT NULL,
`examType` bigint(20) DEFAULT NULL,
`emailId` VARCHAR(255) DEFAULT NULL,
`mobileNumber` VARCHAR(20) DEFAULT NULL,
`mobileCountryCode` VARCHAR(10) DEFAULT NULL,
`description` VARCHAR(255) DEFAULT NULL,
`auditDate` date DEFAULT NULL,
`auditId` bigint NOT NULL,
`lastUpdate` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
`lastUpdatedBy` BIGINT(20) NOT NULL,
PRIMARY KEY (`id`),
CONSTRAINT `FK_nominateExaminers_SU_person` FOREIGN KEY (`personId`) REFERENCES `persons` (`id`),
CONSTRAINT `FK_nominateExaminers_SU_examinerType` FOREIGN KEY (`examinerType`) REFERENCES `examiner_type` (`id`),
CONSTRAINT `FK_nominateExaminers_SU_examType` FOREIGN KEY (`examType`) REFERENCES `exam_type` (`id`),
CONSTRAINT `FK_nominateExaminers_SU_examinerName` FOREIGN KEY (`examinerName`) REFERENCES `users` (`id`),
CONSTRAINT `FK_nominateExaminers_SU_auditId` FOREIGN KEY (`auditId`) REFERENCES `users` (`id`),
CONSTRAINT `FK_nominateExaminers_SU_lastUpdatedBy_FK` FOREIGN KEY (`lastUpdatedBy`) REFERENCES `users`(`id`)
 ) ;
END IF; 

END $$
CALL V20221117171230__Create_NominateExaminers () $$ 
DROP PROCEDURE IF EXISTS V20221117171230__Create_NominateExaminers $$ 
DELIMITER ;